/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.translation.wrapper.form.datachooser;

import com.plusmpm.parser.translation.utils.PackageElementsExtractor;
import com.plusmpm.parser.translation.wrapper.form.datachooser.AbstractDataChooserWrapper;
import com.plusmpm.parser.translation.wrapper.form.datachooser.exception.DataChooserSettingDoesNotExist;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDataChooserWrapper
extends AbstractDataChooserWrapper {
    private static final Logger log = LoggerFactory.getLogger(ComponentDataChooserWrapper.class);

    public ComponentDataChooserWrapper(DataField field) {
        super(field);
    }

    @Override
    protected Map<String, String> getTranslatedMappings() {
        Map<String, JSONObject> mappings = this.getMappings();
        return mappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return ((JSONObject)entry.getValue()).getString("name");
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Cannot read name of mapping " + (String)entry.getKey());
            }
        }));
    }

    private Map<String, JSONObject> getMappings() throws JSONException {
        Optional<ExtendedAttribute> optionalDefinitionAttribute = PackageElementsExtractor.getExtendedAttribute(this.field, "DATA_CHOOSER_DEFINITION");
        if (!optionalDefinitionAttribute.isPresent()) {
            log.error("Cannot find {} in extended attributes of variable {}", (Object)"DATA_CHOOSER_DEFINITION", (Object)this.field.getId());
            return new LinkedHashMap<String, JSONObject>();
        }
        ExtendedAttribute definitionAttribute = optionalDefinitionAttribute.get();
        return this.resolveMappings(definitionAttribute.getVValue());
    }

    private Map<String, JSONObject> resolveMappings(String jsonDefinition) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonDefinition);
        JSONObject mappingsObject = jsonObject.getJSONObject("mappings");
        LinkedHashMap<String, JSONObject> mappings = new LinkedHashMap<String, JSONObject>();
        Iterator iterator = mappingsObject.sortedKeys();
        while (iterator.hasNext()) {
            String mappingName = (String)iterator.next();
            mappings.put(mappingName, mappingsObject.getJSONObject(mappingName));
        }
        return mappings;
    }

    public static boolean isTypeOf(DataField field) {
        return AbstractDataChooserWrapper.isDataChooser(field) && ComponentDataChooserWrapper.isComponentDataChooser(field);
    }

    private static boolean isComponentDataChooser(DataField field) {
        try {
            String dataChooserClass = ComponentDataChooserWrapper.findDataChooserSetting(field, "class");
            return StringUtils.isEmpty((String)dataChooserClass);
        }
        catch (DataChooserSettingDoesNotExist dataChooserSettingDoesNotExist) {
            return false;
        }
    }
}

