package com.plusmpm.parser.translation.wrapper.form.datachooser;

import com.plusmpm.parser.translation.utils.Constants;
import com.plusmpm.parser.translation.wrapper.form.datachooser.exception.DataChooserSettingDoesNotExist;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassDataChooserWrapper
                extends AbstractDataChooserWrapper
{
    public ClassDataChooserWrapper( DataField field )
    {
        super( field );
    }

    @Override
    protected Map<String, String> getTranslatedMappings()
    {
        Map<String, String> result = new LinkedHashMap<>();
        findDataChooserSettings( field )
                        .asMap()
                        .entrySet()
                        .stream()
                        .filter( entry -> entry.getKey().matches( Constants.CLASS_DATA_CHOOSER_MAPPING_PATTERN ) )
                        .map( Map.Entry::getValue )
                        .flatMap( Collection::stream )
                        .map( value -> value.split( ";", -1 ) )
                        .forEach( array -> result.put( array[0], array[2] ) );

        return result;
    }

    public static boolean isTypeOf( DataField field )
    {
        return AbstractDataChooserWrapper.isDataChooser( field ) && isClassDataChooser( field );
    }

    private static boolean isClassDataChooser( DataField field )
    {
        try
        {
            String dataChooserClass = findDataChooserSetting( field, Constants.DATA_CHOOSER_CLASS );
            return StringUtils.isNotEmpty( dataChooserClass );
        }
        catch ( DataChooserSettingDoesNotExist dataChooserSettingDoesNotExist )
        {
            return false;
        }
    }
}