package com.plusmpm.parser.translation.utils;

/**
 * @author Rafał Nowacki 2017-03-22
 */
public class Utils
{
    /**
     * Generuje id dla podanego tekstu. Wszystkie spacje zamieniane są na _, polskie litery
     * zastępowane są zwykłymi znakami, a znaki specjalne są usuwane.
     */
    public static String generateId( String value )
    {
        value = replacePolishLetters( value );
        value = removeSpecialChars( value );
        return value;
    }

    private static String replacePolishLetters( String value )
    {
        return value.replace( "ą", "a" ).replace( "ć", "c" ).replace( "ę", "e" ).replace( "ł", "l" ).replace( "ń", "n" )
                        .replace( "ó", "o" ).replace( "ś", "s" ).replace( "ż", "z" ).replace( "ź", "z" );
    }

    private static String removeSpecialChars( String value )
    {
        return value.replace( " ", "_" ).replaceAll( "[=()]", "" );
    }

    public static String splitValue( String value )
    {
        return value.split( "=" )[0].trim();
    }
}
