/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author Michał Bocian 16-08-2011
 */
@Deprecated
public class Package
    extends XpdlNode
{
	public static final String XPDL_NODE_NAME = "Package";

    private static Logger log = Logger.getLogger( Package.class );

    /**
     * @author Michał Bocian 17-08-2011
     */
    public Package( Node el )
    {
        super( el, null );
    }

    public String getId()
    {
        return "PACK(" + this.id + ")";
    }

    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();

        for ( Participant participant : findParticipants() )
        {
            map.putAll( participant.getProperties() );
        }

        for ( Process process : findProcesses() )
        {
            map.putAll( process.getProperties() );
        }

        return map;
    }

    public List<Process> findProcesses()
    {
        List<Process> processes = new ArrayList<Process>();

        NodeList childrenNodes = node.getChildNodes();

        for ( int i = 0; i < childrenNodes.getLength(); i++ )
        {
            Node child = childrenNodes.item( i );
			if ("WorkflowProcesses".equals(child.getLocalName()))
            {
                NodeList processesNodes = child.getChildNodes();

                for ( int j = 0; j < processesNodes.getLength(); j++ )
                {
                    Node dataFieldNode = processesNodes.item( j );
					if ("WorkflowProcess".equals(dataFieldNode.getLocalName()))
                        processes.add( new Process( dataFieldNode, this ) );
                }
            }
        }
        if ( processes.isEmpty() )
        {
			log.warn("Brak procesów dla: " + getId() + "");
        }

        return processes;
    }

    public List<Participant> findParticipants()
    {
        return Participant.findParticipants( node, this );
    }
}
