/**
 * @author Rafał Nowacki 06-02-2013
 */
package com.plusmpm.parser.wrapper;

/**
 * KROTKI OPIS...
 * 
 * @author Rafał Nowacki 06-02-2013
 */
public class Process
{
    private String processKey;

    public Process( String processKey )
    {
        this.processKey = processKey;
    }

    /**
     * Metoda tworzy klucz PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId) i przekazuje go do obiektu Activity.
     * 
     * @param sActivityId - id zadania
     * @return obiekt Activity zawierający klucz: PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)
     * @author Rafał Nowacki 07-02-2013
     */
    public Activity forActivity( String sActivityId )
    {
        String activityKey = processKey;

        activityKey += "_ACTIVITY(";
        activityKey += sActivityId;
        activityKey += ")";

        return new Activity( activityKey );
    }

    /**
     * Metoda tworzy klucz PACK(sPackageId)_PROC(sProcessId)_PARTICIPANT(sParticipantId) i przekazuje go do obiektu
     * Participant.
     * 
     * @param sParticipantId - id roli
     * @return obiekt Participant zawierający klucz: PACK(sPackageId)_PROC(sProcessId)_PARTICIPANT(sParticipantId)
     * @author Rafał Nowacki 07-02-2013
     */
    public Participant forParticipant( String sParticipantId )
    {
        String participantKey = processKey;

        participantKey += "_PARTICIPANT(";
        participantKey += sParticipantId;
        participantKey += ")";

        return new Participant( participantKey );
    }

    /**
     * Metoda tworzy klucz PACK(sPackageId)_PROC(sProcessId)_DATAFIELD(sDataFieldId) i przekazuje go do obiektu
     * DataField.
     * 
     * @param sDataFieldId - id DataField
     * @return obiekt DataField zawierający klucz: PACK(sPackageId)_PROC(sProcessId)_DataField(sDataFieldId)
     * @author Rafał Nowacki 07-02-2013
     */
    public DataField forDataField( String sDataFieldId )
    {
        String dataFieldKey = processKey;

        dataFieldKey += "_DATAFIELD(";
        dataFieldKey += sDataFieldId;
        dataFieldKey += ")";

        return new DataField( dataFieldKey );
    }

    public ProcessNameMask forProcessNameMask()
    {
        String procNameMaskKey = processKey;

        procNameMaskKey += "_PROCESS_NAME_MASK";

        return new ProcessNameMask( procNameMaskKey );
    }

    /**
     * Metoda zwraca klucz dla procesu: PACK(sPackageId)_PROC(sProcessId)_PROCESS_NAME_MASK
     * 
     * @return PACK(sPackageId)_PROC(sProcessId)_PROCESS_NAME_MASK
     * @author Rafał Nowacki 07-02-2013
     */
    public String getKey()
    {
        return processKey;
    }

    /**
     * Metoda zwraca klucz dla procesu: PACK(sPackageId)_PROC(sProcessId)_DESC
     * 
     * @return PACK(sPackageId)_PROC(sProcessId)_DESC
     * @author Rafał Nowacki 07-02-2013
     */
    public String getKeyDesc()
    {
        return processKey + "_DESC";
    }
}
