/**
 * @author Rafał Nowacki 06-02-2013
 */
package com.plusmpm.parser.wrapper;

/**
 * KROTKI OPIS...
 * 
 * @author Rafał Nowacki 06-02-2013
 */
public class Package
{
    private String packageKey;


    public Package( String packageKey )
    {
        this.packageKey = packageKey;
    }

    /**
     * Metoda tworzy klucz PACK(sPackageId)_PROC(sProcessId) i przekazuje go do obiektu Process.
     * 
     * @param sProcessId - id procesu
     * @return obiekt Process zawierający klucz: PACK(sPackageId)_PROC(sProcessId)
     * @author Rafał Nowacki 07-02-2013
     */
    public Process forProcess( String sProcessId )
    {
        String processKey = packageKey;

        processKey += "_PROC(";
        processKey += sProcessId;
        processKey += ")";

        return new Process( processKey );
    }

    /**
     * Metoda tworzy klucz PACK(sPackageId)_PARTICIPANT(sParticipantId) i przekazuje go do obiektu Participant.
     * 
     * @param sParticipantId - id roli
     * @return obiekt Participant zawierający klucz: PACK(sPackageId)_PARTICIPANT(sParticipantId)
     * @author Rafał Nowacki 07-02-2013
     */
    public Participant forParticipant( String sParticipantId )
    {
        String participantKey = packageKey;

        participantKey += "_PARTICIPANT(";
        participantKey += sParticipantId;
        participantKey += ")";

        return new Participant( participantKey );
    }

    /**
     * Metoda zwraca klucz dla Pakietu: PACK(sPackageId)
     * 
     * @return PACK(sPackageId)
     * @author Rafał Nowacki 07-02-2013
     */
    public String getKey()
    {
        return packageKey;
    }
}