package com.plusmpm.parser.translation.wrapper;

import com.plusmpm.parser.translation.utils.PackageElementsExtractor;
import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Slf4j
@AllArgsConstructor
public class ProcessWrapper
                extends ElementWrapper
{
    private WorkflowProcess process;

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extract( process ).getKey();
    }

    @Override
    public String getRawName()
    {
        return process.getName();
    }

    @Override
    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();

        List<ExtendedAttribute> extendedAttributes = PackageElementsExtractor.getExtendedAttributes( process );
        Optional<ExtendedAttribute> optionalProcessNameMask =
                        PackageElementsExtractor.getProcessNameMask( extendedAttributes );

        if ( optionalProcessNameMask.isPresent() )
        {
            map.put( XpdlKeyResolver.extract( process ).forProcessNameMask().getKey(),
                     optionalProcessNameMask.get().getVValue().split( "_" )[0].trim() );
        }

        for ( ParticipantWrapper participant : findParticipants() )
        {
            map.putAll( participant.getProperties() );
        }

        for ( DataFieldWrapper dataField : findDataFields() )
        {
            map.putAll( dataField.getProperties() );
        }

        for ( ActivityWrapper activity : findActivities() )
        {
            map.putAll( activity.getProperties() );
        }

        map.put( XpdlKeyResolver.extract( process ).getKeyDesc(), process.getProcessHeader().getDescription() );

        return map;
    }

    private List<DataFieldWrapper> findDataFields()
    {
        return PackageElementsExtractor.getDataFields( process ).stream()
                        .map( dataField -> new DataFieldWrapper( dataField ) )
                        .collect( Collectors.toList() );
    }

    private List<ParticipantWrapper> findParticipants()
    {
        return PackageElementsExtractor.getParticipants( process ).stream()
                        .map( participant -> new ParticipantWrapper( participant ) )
                        .collect( Collectors.toList() );
    }

    private List<ActivityWrapper> findActivities()
    {
        return PackageElementsExtractor.getActivities( process ).stream()
                        .map( activity -> new ActivityWrapper( activity ) )
                        .collect( Collectors.toList() );
    }
}
