package com.plusmpm.parser.translation.wrapper;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@AllArgsConstructor
public class PackageWrapper
                extends ElementWrapper
{
    private Package pack;

    public String getKey()
    {
        return XpdlKeyResolver.extract( pack ).getKey();
    }

    @Override public String getRawName()
    {
        return pack.getName();
    }

    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();

        for ( PackageParticipantWrapper participant : findParticipants() )
        {
            map.putAll( participant.getProperties() );
        }

        for ( ProcessWrapper process : findProcesses() )
        {
            map.putAll( process.getProperties() );
        }

        return map;
    }

    private List<ProcessWrapper> findProcesses()
    {
        List<WorkflowProcess> processes = (List<WorkflowProcess>) pack.getWorkflowProcesses().toElements();
        return processes.stream()
                        .map( process -> new ProcessWrapper( process ) )
                        .collect( Collectors.toList() );
    }

    private List<PackageParticipantWrapper> findParticipants()
    {
        List<Participant> packageParticipants = pack.getParticipants().toElements();
        return packageParticipants.stream()
                        .map( participant -> new PackageParticipantWrapper( participant ) )
                        .collect( Collectors.toList() );
    }
}
