package com.plusmpm.parser.translation.wrapper;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

@Data
@AllArgsConstructor
public abstract class ExtendedAttributeWrapper
                extends ElementWrapper
{
    protected ExtendedAttribute attribute;

    protected String[] getRows() {
        return attribute.getVValue().split( "\n" );
    }

    protected String getAttribute( String name )
    {
        String[] rows = getRows();
        for ( String row : rows )
        {
            if ( row.startsWith( name ) )
            {
                return row.split( "=" )[1];
            }
        }

        return StringUtils.EMPTY;
    }
}
