package com.plusmpm.parser.translation.wrapper;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

import java.util.Map;

@Slf4j
public class DtButtonWrapper
                extends ExtendedAttributeWrapper
{
    private static String TOOLTIP_ATTRIBUTE = "tooltip";

    private static String ID_ATTRIBUTE = "id";

    private static String NAME_ATTRIBUTE = "text";

    private static String VARIABLE_SET_ID_ATTRIBUTE = "variableSetId";

    @Setter
    private VariableSetWrapper variableSet;

    public DtButtonWrapper( ExtendedAttribute attribute )
    {
        super( attribute );
    }

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extract( variableSet, this ).getKey();
    }

    @Override
    public String getRawName()
    {
        return getName();
    }

    @Override public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();
        map.put( XpdlKeyResolver.extract( variableSet, this ).getKeyDesc(), getTooltip() );
        return map;
    }

    public String getVariableSetId()
    {
        String variableSetId = getAttribute( VARIABLE_SET_ID_ATTRIBUTE );
        if ( StringUtils.isNotEmpty( variableSetId ) )
        {
            return variableSetId;
        }

        log.error( "Cannot find variableSetId for dtButton " + this.attribute.getVValue() );
        return StringUtils.EMPTY;
    }

    public String getTooltip()
    {
        return getAttribute( TOOLTIP_ATTRIBUTE );
    }

    public String getButtonId()
    {
        String id = getAttribute( ID_ATTRIBUTE );
        if ( StringUtils.isNotEmpty( id ) )
        {
            return id.replaceAll( " ", "_" );
        }

        throw new IllegalArgumentException( "Button does not contain id attribute " + attribute.getVValue() );
    }

    public String getName()
    {
        return getAttribute( NAME_ATTRIBUTE );
    }
}
