package com.plusmpm.parser.translation.wrapper;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

public class ActionButtonWrapper
                extends ExtendedAttributeWrapper
{
    private static String BUTTON_NAME_ATTRIBUTE = "buttonName";

    private static String ID_ATTRIBUTE = "actionName";

    public ActionButtonWrapper( ExtendedAttribute attribute )
    {
        super( attribute );
    }

    @Override public String getKey()
    {
        return XpdlKeyResolver.extract( this ).getKey();
    }

    @Override
    public String getRawName()
    {
        return getName();
    }

    public String getId()
    {
        for ( String row : getRows() )
        {
            if ( row.startsWith( ID_ATTRIBUTE ) )
            {
                return row.split( "=" )[1].replaceAll( " ", "_" );
            }
        }

        throw new IllegalArgumentException( "Cannot find id for action button " + attribute.getVValue() );
    }

    public String getName()
    {
        return getAttribute( BUTTON_NAME_ATTRIBUTE );
    }
}
