package com.plusmpm.parser.translation.utils;

import com.plusmpm.parser.translation.wrapper.*;
import com.plusmpm.parser.wrapper.*;
import com.plusmpm.parser.wrapper.Process;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.*;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;

import static com.plusmpm.parser.translation.utils.Utils.*;

public class XpdlKeyResolver
{
    public static com.plusmpm.parser.wrapper.Package extract( Package packageObj )
    {
        return XpdlKey.forPackage( splitValue( packageObj.getId() ) );
    }

    public static String extractParticipantForPackage( Participant participant )
    {
        Package packageObj = (Package) participant.getParent().getParent();
        return extract( packageObj ).forParticipant( splitValue( participant.getId() ) ).getKey();
    }

    public static Process extract( WorkflowProcess process )
    {
        Package packageObj = (Package) process.getParent().getParent();
        return extract( packageObj ).forProcess( splitValue( process.getId() ) );
    }

    public static com.plusmpm.parser.wrapper.DataField extract( DataField dataField )
    {
        WorkflowProcess process = (WorkflowProcess) dataField.getParent().getParent();
        return extract( process ).forDataField( splitValue( dataField.getId() ) );
    }

    public static com.plusmpm.parser.wrapper.Participant extract( Participant participant )
    {
        WorkflowProcess process = (WorkflowProcess) participant.getParent().getParent();
        return extract( process ).forParticipant( splitValue( participant.getId() ) );
    }

    public static com.plusmpm.parser.wrapper.Activity extract( Activity activity )
    {
        WorkflowProcess process = (WorkflowProcess) activity.getParent().getParent();
        return extract( process ).forActivity( splitValue( activity.getId() ) );
    }

    public static ActionButton extract( ActionButtonWrapper button )
    {
        Activity activity = (Activity) button.getAttribute().getParent().getParent();
        return extract( activity ).forActionButton( splitValue( button.getId() ) );
    }

    public static PdfButton extractPdfButton( PdfButtonWrapper button )
    {
        Activity activity = (Activity) button.getAttribute().getParent().getParent();
        return extract( activity ).forPdfButton( splitValue( button.getId() ) );
    }

    public static AddFileButton extractAddFileButton( AddFileButtonWrapper button )
    {
        Activity activity = (Activity) button.getAttribute().getParent().getParent();
        return extract( activity ).forAddFileButton( splitValue( button.getId() ) );
    }

    public static XpdlElement extractHttpLink( HttpLinkWrapper httpLink )
    {
        Activity activity = (Activity) httpLink.getAttribute().getParent().getParent();
        return extract( activity ).forHttpLink( splitValue( httpLink.getId() ) );
    }

    public static VariableSet extract( VariableSetWrapper variableSet )
    {
        Activity activity = (Activity) variableSet.getAttribute().getParent().getParent();
        com.plusmpm.parser.wrapper.Activity forActivity = extract( activity );

        String tableId = variableSet.getTableId();
        if ( StringUtils.isNotEmpty( tableId ) )
        {
            return forActivity.forVariableSet( tableId );
        }
        else
        {
            return forActivity.forVariableSet( variableSet.getVariableSetNumber() );
        }
    }

    public static DtButton extract( VariableSetWrapper variableSetWrapper,
                                    DtButtonWrapper dtButton )
    {
        return extract( variableSetWrapper ).forDtButton( splitValue( dtButton.getButtonId() ) );
    }
}
