package com.plusmpm.parser.translation.utils;

import com.plusmpm.parser.translation.wrapper.*;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.*;

import java.util.*;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PackageElementsExtractor
{
    public static List<Participant> getParticipants( WorkflowProcess procesess )
    {
        List<Participant> participants = new LinkedList<>();
        for ( Participant participant : (List<Participant>) procesess.getParticipants().toElements() )
        {
            participants.add( participant );
        }

        return participants;
    }

    public static List<ExtendedAttribute> getExtendedAttributes( WorkflowProcess process )
    {
        List<ExtendedAttribute> extendedAttributes = new LinkedList<>();
        for ( ExtendedAttribute extendedAttribute : (List<ExtendedAttribute>) process.getExtendedAttributes()
                        .toElements() )
        {
            extendedAttributes.add( extendedAttribute );
        }

        return extendedAttributes;
    }

    public static Optional<ExtendedAttribute> getProcessNameMask( List<ExtendedAttribute> extendedAttributes )
    {
        return extendedAttributes.stream()
                        .filter( extendedAttribute -> extendedAttribute.getName().equals( "PROCESS_NAME_MASK" ) )
                        .findFirst();
    }

    public static List<DataField> getDataFields( WorkflowProcess process )
    {
        List<DataField> dataFields = new LinkedList<>();
        for ( DataField dataField : (List<DataField>) process.getDataFields().toElements() )
        {
            dataFields.add( dataField );
        }

        return dataFields;
    }

    public static List<Activity> getActivities( WorkflowProcess process )
    {
        List<Activity> activities = new LinkedList<>();
        for ( Activity activity : (List<Activity>) process.getActivities().toElements() )
        {
            activities.add( activity );
        }

        return activities;
    }

    public static List<ExtendedAttribute> getExtendedAttributes( Activity activity )
    {
        List<ExtendedAttribute> extendedAttributes = new LinkedList<>();
        for ( ExtendedAttribute extendedAttribute : (List<ExtendedAttribute>) activity.getExtendedAttributes()
                        .toElements() )
        {
            extendedAttributes.add( extendedAttribute );
        }

        return extendedAttributes;
    }

    public static List<ActionButtonWrapper> getActionAcceptButtons(
                    List<ExtendedAttribute> extendedAttributes )
    {
        return getByName( extendedAttributes, "ACTION_ACCEPT_BUTTON" ).stream()
                        .map( attribute -> new ActionButtonWrapper( attribute ) )
                        .collect( Collectors.toList() );
    }

    public static List<PdfButtonWrapper> getPdfButtons( List<ExtendedAttribute> extendedAttributes )
    {
        return getByName( extendedAttributes, "GENERATE_PDF_BUTTON" ).stream()
                        .map( attribute -> new PdfButtonWrapper( attribute ) )
                        .collect( Collectors.toList() );
    }

    public static List<AddFileButtonWrapper> getAddFileButtons( List<ExtendedAttribute> extendedAttributes )
    {
        return getByName( extendedAttributes, "ADD_FILE_BUTTON" ).stream()
                        .map( attribute -> new AddFileButtonWrapper( attribute ) )
                        .collect( Collectors.toList() );
    }

    public static List<HttpLinkWrapper> getHttpLinks( List<ExtendedAttribute> extendedAttributes )
    {
        return getByName( extendedAttributes, "HTTP_LINK" ).stream()
                        .map( attribute -> new HttpLinkWrapper( attribute ) )
                        .collect( Collectors.toList() );
    }

    private static Map<String, List<DtButtonWrapper>> getDtButtons( List<ExtendedAttribute> extendedAttributes )
    {
        Map<String, List<DtButtonWrapper>> map = new LinkedHashMap<>();
        getByName( extendedAttributes, "DT_BUTTON" ).forEach( dtButton -> {
            DtButtonWrapper buttonWrapper = new DtButtonWrapper( dtButton );
            String variableSetId = buttonWrapper.getVariableSetId();

                if ( !map.containsKey( variableSetId ) )
                {
                    map.put( variableSetId, new LinkedList<>() );
                }

                map.get( variableSetId ).add( buttonWrapper );
        } );

        return map;
    }

    public static List<VariableSetWrapper> getVariableSets( List<ExtendedAttribute> extendedAttributes )
    {
        List<ExtendedAttribute> filteredAttributes = filterBy( extendedAttributes,
                                                               extendedAttribute -> extendedAttribute.getName()
                                                                               .matches( "VARIABLE_SET(|_VIEW)" ) );

        List<VariableSetWrapper> variableSets = new LinkedList<>();
        for ( int i = 0; i < filteredAttributes.size(); i++ )
        {
            Map<String, List<DtButtonWrapper>> dtButtons = getDtButtons( extendedAttributes );

            VariableSetWrapper variableSetWrapper =
                            new VariableSetWrapper( filteredAttributes.get( i ), i );
            String tableId = variableSetWrapper.getTableId();

            List<DtButtonWrapper> buttons = new LinkedList<>();
            if ( dtButtons.containsKey( tableId ) )
            {
                buttons = dtButtons.get( tableId );
            }

            buttons.forEach( button -> button.setVariableSet( variableSetWrapper ) );
            variableSetWrapper.setDtButtons( buttons );

            variableSets.add( variableSetWrapper );
        }

        return variableSets;
    }

    private static List<ExtendedAttribute> getByName( List<ExtendedAttribute> extendedAttributes, String name )
    {
        return filterBy( extendedAttributes, extendedAttribute -> extendedAttribute.getName().equals( name ) );
    }

    private static <T> List<T> filterBy( Collection<T> collection, Predicate<T> predicate )
    {
        return collection.stream()
                        .filter( predicate )
                        .collect( Collectors.toList() );
    }
}
