/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.printer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePrinter {
    private static Logger log = Logger.getLogger(FilePrinter.class);
    private OutputStreamWriter writer;

    public FilePrinter(File file) {
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("B\u0142\u0105d przy dost\u0119pie do pliku: " + file, e);
        }
    }

    public void printProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String property = this.createProperty(entry);
            try {
                this.writer.write(property);
            }
            catch (Exception e) {
                log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d przy zapisywaniu do pliku:");
                log.error((Object)property);
                return;
            }
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d przy pr\u00f3bie zamkni\u0119cia pliku.");
        }
    }

    private String createProperty(Map.Entry<String, String> entry) {
        return entry.getKey() + "=" + entry.getValue() + "\n";
    }
}

