/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.xpdlelements;

import com.plusmpm.parser.xpdlelements.ActionButtonAttr;
import com.plusmpm.parser.xpdlelements.AddFileButtonAttr;
import com.plusmpm.parser.xpdlelements.ExtendedAttribute;
import com.plusmpm.parser.xpdlelements.PdfButtonAttr;
import com.plusmpm.parser.xpdlelements.VariableSetAttr;
import com.plusmpm.parser.xpdlelements.XpdlNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Activity
extends XpdlNode {
    Logger log = Logger.getLogger(Activity.class);

    public Activity(Node el, XpdlNode parentNode) {
        super(el, parentNode);
        this.parentNode = parentNode;
        this.getVariableSets();
        this.getActionButtons();
    }

    private String getDescription() {
        NodeList activityChildren = this.node.getChildNodes();
        for (int i = 0; i < activityChildren.getLength(); ++i) {
            Node child = activityChildren.item(i);
            if (!"Description".equals(child.getLocalName())) continue;
            return child.getFirstChild().getNodeValue().replaceAll("\n", "<br>");
        }
        this.log.info((Object)("Zadanie: " + this.id + " nie posiada opisu!"));
        return "";
    }

    @Override
    public String getId() {
        return this.parentNode.getId() + "_ACTIVITY(" + this.id + ")";
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        for (ExtendedAttribute actionButton : this.getActionButtons()) {
            map.putAll(actionButton.getProperties());
        }
        for (VariableSetAttr variableSet : this.getVariableSets()) {
            map.putAll(variableSet.getProperties());
        }
        map.put(this.parentNode.getId() + "_ACTIVITY(" + this.id + ")_DESC", this.getDescription());
        return map;
    }

    public List<VariableSetAttr> getVariableSets() {
        ArrayList<VariableSetAttr> variableSets = new ArrayList<VariableSetAttr>();
        int nr = 0;
        NodeList extendedAttrs = this.getExtendedAttributes();
        for (int j = 0; j < extendedAttrs.getLength(); ++j) {
            Node extendedAttr = extendedAttrs.item(j);
            try {
                String name = extendedAttr.getAttributes().getNamedItem("Name").toString();
                name = this.splitValue(name);
                if (!name.matches("VARIABLE_SET(|_VIEW)")) continue;
                variableSets.add(new VariableSetAttr(extendedAttr, this, nr));
                ++nr;
                continue;
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        return variableSets;
    }

    private List<ExtendedAttribute> getActionButtons() {
        ArrayList<ExtendedAttribute> actionButtons = new ArrayList<ExtendedAttribute>();
        NodeList extendedAttrs = this.getExtendedAttributes();
        for (int j = 0; j < extendedAttrs.getLength(); ++j) {
            Node extendedAttr = extendedAttrs.item(j);
            try {
                String name = extendedAttr.getAttributes().getNamedItem("Name").toString();
                name = this.splitValue(name);
                if (name.equals("ACTION_ACCEPT_BUTTON")) {
                    actionButtons.add(new ActionButtonAttr(extendedAttr, this));
                    continue;
                }
                if (name.equals("GENERATE_PDF_BUTTON")) {
                    actionButtons.add(new PdfButtonAttr(extendedAttr, this));
                    continue;
                }
                if (!name.equals("ADD_FILE_BUTTON")) continue;
                actionButtons.add(new AddFileButtonAttr(extendedAttr, this));
                continue;
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        return actionButtons;
    }
}

