/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.xpdlelements;

import com.plusmpm.parser.xpdlelements.ExtendedAttribute;
import com.plusmpm.parser.xpdlelements.XpdlNode;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class ActionButtonAttr
extends ExtendedAttribute {
    private static Logger log = Logger.getLogger(ActionButtonAttr.class);
    private String[] rows;

    public ActionButtonAttr(Node el, XpdlNode parentNode) {
        String valueAttr = el.getAttributes().getNamedItem("Value").getNodeValue();
        this.rows = valueAttr.split("\n");
        this.parentNode = parentNode;
        this.id = this.getId();
        this.name = this.getName();
        this.node = el;
    }

    @Override
    public String getId() {
        for (String row : this.rows) {
            if (!row.startsWith("actionName")) continue;
            return this.parentNode.getId() + "_ACTIONBUTTON(" + row.split("=")[1].replaceAll(" ", "_") + ")";
        }
        log.error((Object)"ActionButton nie posiada id!");
        throw new IllegalArgumentException();
    }

    @Override
    public String getName() {
        for (String row : this.rows) {
            if (!row.startsWith("buttonName")) continue;
            return row.split("=")[1];
        }
        log.warn((Object)("Button w zadaniu: " + this.getId() + " nie ma zdefiniowanej nazwy!"));
        return "";
    }
}

