/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.xpdlelements;

import com.plusmpm.parser.xpdlelements.Activity;
import com.plusmpm.parser.xpdlelements.DataField;
import com.plusmpm.parser.xpdlelements.Participant;
import com.plusmpm.parser.xpdlelements.ProcessNameMaskAttr;
import com.plusmpm.parser.xpdlelements.XpdlNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Process
extends XpdlNode {
    private static Logger log = Logger.getLogger(Process.class);

    public Process(Node el, XpdlNode parentNode) {
        super(el, parentNode);
    }

    @Override
    public String getId() {
        return this.parentNode.getId() + "_PROC(" + this.id + ")";
    }

    private List<Activity> findActivities() {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        NodeList childrenNodes = this.node.getChildNodes();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node child = childrenNodes.item(i);
            if (!child.getNodeName().equals("xpdl:Activities")) continue;
            NodeList participantNodes = child.getChildNodes();
            for (int j = 0; j < participantNodes.getLength(); ++j) {
                Node participantNode = participantNodes.item(j);
                if (!participantNode.getNodeName().equals("xpdl:Activity")) continue;
                activities.add(new Activity(participantNode, this));
            }
        }
        if (activities.isEmpty()) {
            log.warn((Object)("Brak zada\u0144 dla: '" + this.getId() + " lub maj\u0105 inny namespace ni\u017c: xpdl:Activities"));
        }
        return activities;
    }

    private String getDescription() {
        NodeList activityChildren = this.node.getChildNodes();
        for (int i = 0; i < activityChildren.getLength(); ++i) {
            Node child = activityChildren.item(i);
            if (!child.getNodeName().equals("xpdl:ProcessHeader")) continue;
            NodeList processHeader = child.getChildNodes();
            for (int j = 0; j < processHeader.getLength(); ++j) {
                Node header = processHeader.item(j);
                if (!header.getNodeName().equals("xpdl:Description")) continue;
                return header.getFirstChild().getNodeValue();
            }
        }
        log.warn((Object)("Proces: " + this.id + " nie posiada opisu!"));
        return "";
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.getId(), this.name);
        ProcessNameMaskAttr ea = this.getProcessNameMask();
        if (ea != null) {
            map.putAll(ea.getProperties());
        }
        for (Participant participant : this.findParticipants()) {
            map.putAll(participant.getProperties());
        }
        for (DataField dataField : this.findDataFields()) {
            map.putAll(dataField.getProperties());
        }
        for (Activity activity : this.findActivities()) {
            map.putAll(activity.getProperties());
        }
        map.put(this.parentNode.getId() + "_PROC(" + this.id + ")_DESC", this.getDescription());
        return map;
    }

    private List<DataField> findDataFields() {
        return DataField.findDataFields(this.node, this);
    }

    private List<Participant> findParticipants() {
        return Participant.findParticipants(this.node, this);
    }

    private ProcessNameMaskAttr getProcessNameMask() {
        NodeList extendedAttrs = this.getExtendedAttributes();
        for (int j = 0; j < extendedAttrs.getLength(); ++j) {
            Node extendedAttr = extendedAttrs.item(j);
            try {
                String name = extendedAttr.getAttributes().getNamedItem("Name").toString();
                name = this.splitValue(name);
                if (!name.equals("PROCESS_NAME_MASK")) continue;
                return new ProcessNameMaskAttr(extendedAttr, this);
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        return null;
    }
}

