/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.xpdlelements;

import com.plusmpm.parser.xpdlelements.Participant;
import com.plusmpm.parser.xpdlelements.Process;
import com.plusmpm.parser.xpdlelements.XpdlNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Package
extends XpdlNode {
    public static final String XPDL_NODE_NAME = "xpdl:Package";
    private static Logger log = Logger.getLogger(Package.class);

    public Package(Node el) {
        super(el, null);
    }

    @Override
    public String getId() {
        return "PACK(" + this.id + ")";
    }

    public Package getPackage(Document document) {
        NodeList participantNodes = document.getElementsByTagName(XPDL_NODE_NAME);
        Package xpdlpackage = new Package(participantNodes.item(0));
        return xpdlpackage;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        for (Participant participant : this.findParticipants()) {
            map.putAll(participant.getProperties());
        }
        for (Process process : this.findProcesses()) {
            map.putAll(process.getProperties());
        }
        return map;
    }

    public List<Process> findProcesses() {
        ArrayList<Process> processes = new ArrayList<Process>();
        NodeList childrenNodes = this.node.getChildNodes();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node child = childrenNodes.item(i);
            if (!child.getNodeName().equals("xpdl:WorkflowProcesses")) continue;
            NodeList processesNodes = child.getChildNodes();
            for (int j = 0; j < processesNodes.getLength(); ++j) {
                Node dataFieldNode = processesNodes.item(j);
                if (!dataFieldNode.getNodeName().equals("xpdl:WorkflowProcess")) continue;
                processes.add(new Process(dataFieldNode, this));
            }
        }
        if (processes.isEmpty()) {
            log.warn((Object)("Brak proces\u00f3w dla: " + this.getId() + " lub maj\u0105 inny namespace ni\u017c: xpdl:WorkflowProcesses"));
        }
        return processes;
    }

    public List<Participant> findParticipants() {
        return Participant.findParticipants(this.node, this);
    }
}

