/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.printer;

import com.plusmpm.parser.printer.Printer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FilePrinter
implements Printer {
    private static Logger log = Logger.getLogger(FilePrinter.class);
    private OutputStreamWriter writer;

    public FilePrinter(String url) {
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(url), "UTF-8");
        }
        catch (IOException e) {
            log.error((Object)"B\u0142\u0105d przy dost\u0119pie do pliku: ".concat(url), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void print(HashMap<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String property = this.createProperty(entry);
            try {
                this.writer.write(property);
            }
            catch (Exception e) {
                log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d przy zapisywaniu do pliku:");
                log.error((Object)property);
                return;
            }
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d przy pr\u00f3bie zamkni\u0119cia pliku.");
        }
    }

    private String createProperty(Map.Entry<String, String> entry) {
        String result = "";
        result = result.concat(entry.getKey()).concat("=").concat(entry.getValue()).concat("\n");
        return result;
    }
}

