/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.xpdlelements;

import com.plusmpm.parser.xpdlelements.ExtendedAttribute;
import com.plusmpm.parser.xpdlelements.XpdlNode;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DtButtonAttr
extends ExtendedAttribute {
    private static Logger log = Logger.getLogger(DtButtonAttr.class);
    private String[] rows;
    private String buttonId;
    private String variableSetId;

    public DtButtonAttr(Node el, XpdlNode parentNode) {
        String valueAttr = el.getAttributes().getNamedItem("Value").getNodeValue();
        this.rows = valueAttr.split("\n");
        this.parentNode = parentNode;
        this.node = el;
        this.buttonId = this.getButtonId();
        this.name = this.getName();
        this.variableSetId = this.resolveVariableSetId();
        this.id = this.getId();
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put(this.getId() + "_DESC", this.getTooltip());
        return map;
    }

    private String getTooltip() {
        for (String row : this.rows) {
            if (!row.startsWith("tooltip")) continue;
            return row.split("=")[1];
        }
        return "";
    }

    public String getVariableSetId() {
        return this.variableSetId;
    }

    private String getButtonId() {
        for (String row : this.rows) {
            if (!row.startsWith("id")) continue;
            return row.split("=")[1].replaceAll(" ", "_");
        }
        log.error((Object)"DtButton nie posiada id!");
        throw new IllegalArgumentException();
    }

    private String resolveVariableSetId() {
        for (String row : this.rows) {
            if (!row.startsWith("variableSetId")) continue;
            return row.split("=")[1];
        }
        log.warn((Object)("DtButton w zadaniu: " + this.getId() + " nie jest przypisany do \u017cadnej tabeli!"));
        return "";
    }

    @Override
    public String getId() {
        return this.parentNode.getId() + "_DTBUTTON(" + this.buttonId + ")";
    }

    @Override
    public String getName() {
        for (String row : this.rows) {
            if (!row.startsWith("text")) continue;
            return row.split("=")[1];
        }
        log.warn((Object)("DtButton w zadaniu: " + this.getId() + " nie ma zdefiniowanej nazwy!"));
        return "";
    }

    public void setParentNode(XpdlNode parentNode) {
        this.parentNode = parentNode;
    }
}

