/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.xpdlelements;

import com.plusmpm.parser.xpdlelements.ActionButtonAttr;
import com.plusmpm.parser.xpdlelements.AddFileButtonAttr;
import com.plusmpm.parser.xpdlelements.DtButtonAttr;
import com.plusmpm.parser.xpdlelements.ExtendedAttribute;
import com.plusmpm.parser.xpdlelements.HttpLinkAttr;
import com.plusmpm.parser.xpdlelements.PdfButtonAttr;
import com.plusmpm.parser.xpdlelements.VariableSetAttr;
import com.plusmpm.parser.xpdlelements.XpdlNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activity
extends XpdlNode {
    Logger log = Logger.getLogger(Activity.class);

    public Activity(Node el, XpdlNode parentNode) {
        super(el, parentNode);
        this.parentNode = parentNode;
    }

    private String getDescription() {
        NodeList activityChildren = this.node.getChildNodes();
        for (int i = 0; i < activityChildren.getLength(); ++i) {
            Node child = activityChildren.item(i);
            if (!"Description".equals(child.getLocalName())) continue;
            return child.getFirstChild().getNodeValue().replaceAll("\n", "<br>");
        }
        this.log.trace((Object)("Zadanie: " + this.id + " nie posiada opisu!"));
        return "";
    }

    @Override
    public String getId() {
        return this.parentNode.getId() + "_ACTIVITY(" + this.id + ")";
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        NodeList extendedAttrs = this.getExtendedAttributes();
        for (ExtendedAttribute actionButton : this.getActionButtons(extendedAttrs)) {
            map.putAll(actionButton.getProperties());
        }
        for (HttpLinkAttr httpLink : this.getHttpLinks(extendedAttrs)) {
            map.putAll(httpLink.getProperties());
        }
        for (VariableSetAttr variableSet : this.getVariableSets(extendedAttrs)) {
            map.putAll(variableSet.getProperties());
        }
        map.put(this.parentNode.getId() + "_ACTIVITY(" + this.id + ")_DESC", this.getDescription());
        return map;
    }

    public List<VariableSetAttr> getVariableSets(NodeList extendedAttrs) {
        ArrayList<VariableSetAttr> variableSets = new ArrayList<VariableSetAttr>();
        int nr = 0;
        Map<String, List<DtButtonAttr>> dtButtons = this.getDtButtons(extendedAttrs);
        for (int j = 0; j < extendedAttrs.getLength(); ++j) {
            Node extendedAttr = extendedAttrs.item(j);
            try {
                NamedNodeMap attributes = extendedAttr.getAttributes();
                if (attributes == null) continue;
                String name = attributes.getNamedItem("Name").toString();
                if (!(name = this.splitValue(name)).matches("VARIABLE_SET(|_VIEW)")) continue;
                VariableSetAttr variableSet = new VariableSetAttr(extendedAttr, this, nr++);
                variableSet.setDtButtons(dtButtons.get(variableSet.getTableId()));
                variableSets.add(variableSet);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"B\u0142\u0105d podczas odczytu tabeli dynamicznej", (Throwable)e);
            }
        }
        return variableSets;
    }

    private List<ExtendedAttribute> getActionButtons(NodeList extendedAttrs) {
        ArrayList<ExtendedAttribute> actionButtons = new ArrayList<ExtendedAttribute>();
        for (int j = 0; j < extendedAttrs.getLength(); ++j) {
            Node extendedAttr = extendedAttrs.item(j);
            try {
                String name = extendedAttr.getAttributes().getNamedItem("Name").toString();
                name = this.splitValue(name);
                if (name.equals("ACTION_ACCEPT_BUTTON")) {
                    actionButtons.add(new ActionButtonAttr(extendedAttr, this));
                    continue;
                }
                if (name.equals("GENERATE_PDF_BUTTON")) {
                    actionButtons.add(new PdfButtonAttr(extendedAttr, this));
                    continue;
                }
                if (!name.equals("ADD_FILE_BUTTON")) continue;
                actionButtons.add(new AddFileButtonAttr(extendedAttr, this));
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return actionButtons;
    }

    private Map<String, List<DtButtonAttr>> getDtButtons(NodeList extendedAttrs) {
        HashMap<String, List<DtButtonAttr>> dtButtons = new HashMap<String, List<DtButtonAttr>>();
        for (int j = 0; j < extendedAttrs.getLength(); ++j) {
            Node extendedAttr = extendedAttrs.item(j);
            try {
                String name = extendedAttr.getAttributes().getNamedItem("Name").toString();
                name = this.splitValue(name);
                if (!name.equals("DT_BUTTON")) continue;
                DtButtonAttr dtButton = new DtButtonAttr(extendedAttr, this);
                if (!dtButtons.containsKey(dtButton.getVariableSetId())) {
                    dtButtons.put(dtButton.getVariableSetId(), new ArrayList());
                }
                ((List)dtButtons.get(dtButton.getVariableSetId())).add(dtButton);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return dtButtons;
    }

    private List<HttpLinkAttr> getHttpLinks(NodeList extendedAttrs) {
        ArrayList<HttpLinkAttr> httpLinks = new ArrayList<HttpLinkAttr>();
        for (int j = 0; j < extendedAttrs.getLength(); ++j) {
            Node extendedAttr = extendedAttrs.item(j);
            try {
                String name = extendedAttr.getAttributes().getNamedItem("Name").toString();
                name = this.splitValue(name);
                if (!name.equals("HTTP_LINK")) continue;
                httpLinks.add(new HttpLinkAttr(extendedAttr, this));
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return httpLinks;
    }
}

