/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser;

import com.plusmpm.parser.printer.FilePrinter;
import com.plusmpm.parser.xpdlelements.Package;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XpdlParser {
    private static Logger log = Logger.getLogger(XpdlParser.class);
    public static final String[] LANGUAGE_CONSTANTS = new String[]{"pl"};

    public static Package parse(byte[] xpdl) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xpdl);
        Document document = builder.parse(inputStream);
        Node packNode = document.getChildNodes().item(0);
        return new Package(packNode);
    }

    public static void parse(String[] urlToXpdl) {
        XpdlParser.parse(urlToXpdl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(String[] urlToXpdl, String urlToProperties) {
        log.info((Object)"Rozpoczynam parsowanie");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            HashMap<String, String> resultMap = new HashMap<String, String>();
            for (String pathToXpdl : urlToXpdl) {
                Document document = builder.parse(pathToXpdl);
                Node packNode = document.getChildNodes().item(0);
                if (!"Package".equals(packNode.getLocalName())) {
                    log.warn((Object)("Namespace pakietu: '" + packNode.getNodeName() + "' jest inny ni\u017c 'Package'"));
                }
                Package pack = new Package(packNode);
                resultMap.putAll(pack.getProperties());
            }
            FilePrinter filePrinter = new FilePrinter(new File(urlToProperties + "/xpdlMessages.i18n"));
            filePrinter.printProperties(resultMap);
        }
        catch (FactoryConfigurationError e) {
            log.error((Object)"Nie mo\u017cna stworzy\u0107 fabryki konfiguracji", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"XPDL zawiera b\u0142\u0119dy", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"B\u0142\u0105d parsowania", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"B\u0142\u0105d wej\u015bcia/wyj\u015bcia", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Nieznany b\u0142\u0105d", (Throwable)e);
        }
        finally {
            log.info((Object)"Zakonczono parsowanie");
        }
    }

    public static void main(String[] args) {
        String[] pathsToXpdl = null;
        String pathToProperties = null;
        if (args.length == 0) {
            log.error((Object)"Nie podano \u015bcie\u017cki do XPDL");
            log.error((Object)"Mo\u017cliwe parametry to:");
            log.error((Object)"\t -i <sciezka> ( obowiazkowe )  bezwzgl\u0119dna \u015bcie\u017cka do pliku XPDL");
            log.error((Object)"\t -o <sciezka> ( opcjonalne ) \u015bcie\u017cka do wygenerowanego pliku .properties");
            return;
        }
        if (args[0].equals("-i")) {
            String argXpdlPaths = args[1];
            for (String pathToXpdl : pathsToXpdl = argXpdlPaths.split(",")) {
                File file = new File(pathToXpdl);
                if (file.exists()) continue;
                log.error((Object)"Plik: ".concat(pathToXpdl).concat(" nie istnieje."));
                return;
            }
        }
        if (args.length == 4 && args[2].equals("-o")) {
            pathToProperties = args[3];
        }
        XpdlParser.parse(pathsToXpdl, pathToProperties);
    }
}

