/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Klasa reprezentująca każdy węzeł w pliku xpdl. Dziedziczą z niej wszystkie inne elementy Każdy węzeł posiada swoje
 * <code>id</code> i odpowiadającą mu nazwę: <code>name</code>
 * 
 * @author Michał Bocian 16-08-2011
 */
public abstract class XpdlNode
    implements Parsable
{
    /**
     * Logger log4j
     */
    private static Logger log = Logger.getLogger( XpdlNode.class );

    /**
     * Każdy węzeł musi posiadać przodka, m.in. dlatego, żeby dobrze określić swoje <code>id</code>
     */
    XpdlNode parentNode;

    /**
     * Id węzła
     */
    String id;

    /**
     * Nazwa węzła
     */
    String name;

    /**
     * Obiekt xml, który reprezentuje dany węzeł
     */
    Node node;

    /**
     * Domyślny konstruktor
     * 
     * @author Michał Bocian 25-08-2011
     */
    protected XpdlNode()
    {
    }

    /**
     * Konstruktor ustalający podstawowe pola w klasie {@link XpdlNode}
     * 
     * @param el
     * @param parentNode
     * @author Michał Bocian 25-08-2011
     */
    public XpdlNode( Node el, XpdlNode parentNode )
    {
        this.parentNode = parentNode;

        this.id = el.getAttributes().getNamedItem( "Id" ).toString();
        this.id = splitValue( this.id );
        try
        {
            this.name = el.getAttributes().getNamedItem( "Name" ).toString();
            this.name = splitValue( this.name );
        }
        catch ( NullPointerException npe )
        {
            log.warn( "Atrybut o id: ".concat( this.id ).concat( " nie ma podanej nazwy!" ) );
            this.name = "";
        }

        this.node = el;

    }

    /**
     * {@link Parsable#getProperties()}
     */
    public Map<String, String> getProperties()
    {
		Map<String, String> map = new LinkedHashMap<String, String>();
		map.put(this.getId(), this.getName());

        return map;
    }

    /**
     * Funkcja zwracająca wartość z danej
     * 
     * @param value Krotka w postaci id=wartość
     * @return Zwraca wartość z łańcucha id=wartość
     * @author Michał Bocian 25-08-2011
     */
    public String splitValue( String value )
    {
        String result = "";
        result = value.split( "=" )[1];

        result = result.substring( 1, result.length() - 1 );

        return result;
    }

    /**
     * Pobiera id węzła
     * 
     * @return id
     * @author Michał Bocian 25-08-2011
     */
    public String getId()
    {
        return id;
    }

    /**
     * Pobiera nazwę węzła
     * 
     * @return nazwa węzła
     * @author Michał Bocian 25-08-2011
     */
    public String getName()
    {
        return name;
    }

    /**
     * Pobiera atrybuty rozszrzone dla określonego węzła
     * 
     * @return NodeList z atrybutami rozszerzonymi lub null w przypadku gdy nic nie znajdzie
     * @author Michał Bocian 12-09-2011
     */
    protected NodeList getExtendedAttributes()
    {
        NodeList list = node.getChildNodes();

        for ( int i = 0; i < list.getLength(); i++ )
        {
			if ("ExtendedAttributes".equals(list.item(i).getLocalName()))
            {
                return list.item( i ).getChildNodes();
            }
        }
        return null;
    }
}