package com.plusmpm.parser.xpdlelements;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class AddFileButtonAttr
    extends ExtendedAttribute
{
    private static Logger log = Logger.getLogger( AddFileButtonAttr.class );

    private String[] rows;

    public AddFileButtonAttr( Node el, XpdlNode parentNode )
    {
        super();

        String valueAttr = el.getAttributes().getNamedItem( "Value" ).getNodeValue();
        this.rows = valueAttr.split( "\n" );

        this.parentNode = parentNode;
        this.id = getId();
        this.name = getName();
        this.node = el;
    }

    @Override
    public String getId()
    {
        for ( String row : rows )
        {
            if ( row.toUpperCase().startsWith( "ClassName".toUpperCase() ) )
            {
                return parentNode.getId() + "_ADDFILEBUTTON(" + row.split( "=" )[1].replace( " ", "_" ) + ")";
            }
        }
        log.error( "ADD_FILE_BUTTON nie posiada zdefiniowanej klasy dokumentów!" );
        throw new IllegalArgumentException();
    }

    @Override
    public String getName()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "buttonName" ) )
            {
                return row.split( "=" )[1];
            }
        }
        log.warn( "Button w zadaniu: " + getId() + " nie ma zdefiniowanej nazwy!" );
        return "";
    }
}
