/**
 * @author Rafał Nowacki 07-02-2013
 */
package com.plusmpm.parser.wrapper;

/**
 * KROTKI OPIS...
 * 
 * @author Rafał Nowacki 07-02-2013
 */
public class VariableSet
{
    private String variableSetKey;

    public VariableSet( String variableSetKey )
    {
        this.variableSetKey = variableSetKey;
    }

    /**
     * Metoda tworzy klucz
     * PACK(packageId)_PROC(processId)_ACTIVITY(activityId)_DTBUTTON(dtButton)
     * 
     * @param dtButton
     */
    public DtButton forDtButton( String dtButton )
    {
        String dtButtonKey = variableSetKey;

        dtButtonKey += "_DTBUTTON(";
        dtButtonKey += dtButton;
        dtButtonKey += ")";

        return new DtButton( dtButtonKey );
    }

    /**
     * Metoda zwraca klucz dla VariableSet
     * 
     * @return PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_VARIABLESET(iNumber)
     * @author Rafał Nowacki 07-02-2013
     */
    public String getKey()
    {
        return variableSetKey;
    }
}
