/**
 * @author Rafał Nowacki 06-02-2013
 */
package com.plusmpm.parser.wrapper;

import com.plusmpm.parser.Utils;

/**
 * KROTKI OPIS...
 * 
 * @author Rafał Nowacki 06-02-2013
 */
public class Activity
{
    private String activityKey;

    public Activity( String activityKey )
    {
        this.activityKey = activityKey;
    }

    /**
     * Metoda tworzy klucz
     * PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_ACTIONBUTTON(sActionButtonId) i
     * przekazuje go do obiektu ActionButton.
     * 
     * @param sActionButtonId - id buttona
     * @return obiekt ActionButton zawierający klucz:
     *         PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_ACTIONBUTTON(sActionButtonId)
     * @author Rafał Nowacki 07-02-2013
     */
    public ActionButton forActionButton( String sActionButtonId )
    {
        String actionButtonKey = activityKey;

        actionButtonKey += "_ACTIONBUTTON(";
        actionButtonKey += sActionButtonId;
        actionButtonKey += ")";

        return new ActionButton( actionButtonKey );
    }

    /**
     * Metoda tworzy klucz
     * PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_ADDFILEBUTTON(sAddFileButtonId) i
     * przekazuje go do obiektu AddFileButton.
     * 
     * @param sAddFileButtonId - id buttona
     * @return obiekt AddFileButton zawierający klucz:
     *         PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_ADDFILEBUTTON(sAddFileButtonId)
     * @author Rafał Nowacki 07-02-2013
     */
    public AddFileButton forAddFileButton( String sAddFileButtonId )
    {
        String addFileButtonKey = activityKey;

        addFileButtonKey += "_ADDFILEBUTTON(";
        addFileButtonKey += sAddFileButtonId;
        addFileButtonKey += ")";

        return new AddFileButton( addFileButtonKey );
    }

    /**
     * Metoda tworzy klucz
     * PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_PDFBUTTON(sPdfButtonId) i przekazuje
     * go do obiektu PdfButton.
     * 
     * @param sPdfButtonId - id buttona
     * @return obiekt PdfButton zawierający klucz:
     *         PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_PDFBUTTON(sPdfButtonId)
     * @author Rafał Nowacki 07-02-2013
     */
    public PdfButton forPdfButton( String sPdfButtonId )
    {
        String pdfButtonKey = activityKey;

        pdfButtonKey += "_PDFBUTTON(";
        pdfButtonKey += sPdfButtonId;
        pdfButtonKey += ")";

        return new PdfButton( pdfButtonKey );
    }

    /**
     * Metoda tworzy klucz
     * PACK(packageId)_PROC(processId)_ACTIVITY(activityId)_HTTPLINK(httpLinkName)
     * 
     * @param httpLinkName
     */
    public XpdlElement forHttpLink( String httpLinkName )
    {
        String httpLinkKey = activityKey;

        httpLinkKey += "_HTTPLINK(";
        httpLinkKey += Utils.generateId( httpLinkName );
        httpLinkKey += ")";

        return new XpdlElement( httpLinkKey );
    }

    /**
     * Metoda tworzy klucz
     * PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_VARIABLESET(iNumber) i przekazuje go
     * do obiektu VariableSet.
     * 
     * @param variableSetId - identyfikator VariableSet
     * @return obiekt VariableSet zawierający klucz:
     *         PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_VARIABLESET(iNumber)
     * @author Rafał Nowacki 07-02-2013
     */
    public VariableSet forVariableSet( String variableSetId )
    {
        String variableSetKey = activityKey;

        variableSetKey += "_VARIABLESET(";
        variableSetKey += variableSetId;
        variableSetKey += ")";

        return new VariableSet( variableSetKey );
    }

    public VariableSet forVariableSet( int variableSetNo )
    {
        return forVariableSet( String.valueOf( variableSetNo ) );
    }

    /**
     * Metoda zwraca klucz dla zadania: PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)
     * 
     * @return PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)
     * @author Rafał Nowacki 07-02-2013
     */
    public String getKey()
    {
        return activityKey;
    }

    /**
     * Metoda zwraca klucz dla zadania: PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_DESC
     * 
     * @return PACK(sPackageId)_PROC(sProcessId)_ACTIVITY(sActivityId)_DESC
     * @author Rafał Nowacki 07-02-2013
     */
    public String getKeyDesc()
    {
        return activityKey + "_DESC";
    }
}
