/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

/**
 * @author Michał Bocian 12-09-2011
 */
public class ProcessNameMaskAttr
    extends ExtendedAttribute
{
    Logger log = Logger.getLogger( ProcessNameMaskAttr.class );

    /**
     * @author Michał Bocian 12-09-2011
     */
    public ProcessNameMaskAttr( Node el, XpdlNode parentNode )
    {
        super();

        this.node = el;
        this.parentNode = parentNode;

        this.id = getId();
        this.name = getName();

    }

    /**
     * @see com.plusmpm.parser.xpdlelements.XpdlNode#getId()
     */
    @Override
    public String getId()
    {
        return parentNode.getId() + "_" + "PROCESS_NAME_MASK";
    }

    /**
     * @see com.plusmpm.parser.xpdlelements.XpdlNode#getName()
     */
    @Override
    public String getName()
    {
        String valueAttr = node.getAttributes().getNamedItem( "Value" ).getNodeValue();

        String mask = "";
        try
        {
            mask = ( valueAttr.split( "_" ) )[0].trim();
        }
        catch ( Exception e )
        {
            log.error( "Wartość atrybutu \"PROCESS NAME MASK\" w procesie: " + parentNode.getId() + " jest nieprawidłowa", e );
        }

        return mask;
    }
}
