/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

/**
 * @author Michał Bocian 17-08-2011
 */
public class PdfButtonAttr
    extends ExtendedAttribute
{
    private static Logger log = Logger.getLogger( PdfButtonAttr.class );

    private String[] rows;

    public PdfButtonAttr( Node el, XpdlNode parentNode )
    {
        super();

        String valueAttr = el.getAttributes().getNamedItem( "Value" ).getNodeValue();
        this.rows = valueAttr.split( "\n" );

        this.parentNode = parentNode;
        this.id = getId();
        this.name = getName();
        this.node = el;
    }

    public String getId()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "Template" ) )
            {
                return parentNode.getId() + "_PDFBUTTON(" + row.split( "=" )[1].replaceAll( " ", "_" ) + ")";
            }
        }
        log.error( "PdfButton nie posiada template'u!" );
        throw new IllegalArgumentException();
    }

    public String getName()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "buttonName" ) )
            {
                return row.split( "=" )[1];
            }
        }
        log.warn( "Button w zadaniu: " + getId() + " nie ma zdefiniowanej nazwy!" );
        return "";
    }
}
