/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import java.util.Map;

/**
 * Interfejs, mówiący o tym, że dana klasa implenentująca interfejs daje mozliwość przekonwertowania siebie i swoich
 * potomków do plików .properties
 *
 * @author Michał Bocian 17-08-2011
 */
public interface Parsable
{
    /**
     * Funkcja, którą odpowiada za zwrócenie wyniku, kompatybilnego z plikami properties w postaci id=name
     * Każda klasa rozszerzajaca {@link XpdlNode} w zależności od tego czy pod dany węzeł podlegają inne węzły
     * potencjalnie zawierające pary id=wartość powinna implementować tą metodę, aby w sposób kompletny zwrócić mapę
     * wszystkich swoich pól do przetłumaczenia, jak i pól swoich dzieci
     */
    public Map<String, String> getProperties();
}
