package com.plusmpm.parser.xpdlelements;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

import com.plusmpm.parser.Utils;

/**
 * @author Rafał Nowacki 2017-03-22
 */
public class HttpLinkAttr
    extends ExtendedAttribute
{
    private static Logger log = Logger.getLogger( HttpLinkAttr.class );

    private String[] rows;

    public HttpLinkAttr( Node el, XpdlNode parentNode )
    {
        super();

        String valueAttr = el.getAttributes().getNamedItem( "Value" ).getNodeValue();
        this.rows = valueAttr.split( "\n" );

        this.parentNode = parentNode;
        this.name = getName();
        this.id = getId();
        this.node = el;

    }

    public String getId()
    {
        return parentNode.getId() + "_HTTPLINK(" + Utils.generateId( this.name ) + ")";
    }

    public String getName()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "Name" ) )
            {
                return row.split( "=", 2 )[1];
            }
        }
        log.warn( "HttpLink w zadaniu: " + parentNode.getId() + " nie ma zdefiniowanej nazwy!" );
        throw new IllegalArgumentException();
    }
}
