/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author Michał Bocian 16-08-2011
 */
public class Activity
    extends XpdlNode
{
    Logger log = Logger.getLogger( Activity.class );

    public Activity( Node el, XpdlNode parentNode )
    {
        super( el, parentNode );

        this.parentNode = parentNode;
    }

    private String getDescription()
    {
        NodeList activityChildren = node.getChildNodes();
        for ( int i = 0; i < activityChildren.getLength(); i++ )
        {
            Node child = activityChildren.item( i );
            if ( "Description".equals( child.getLocalName() ) )
            {
                return child.getFirstChild().getNodeValue().replaceAll( "\n", "<br>" );
            }
        }
        log.info( "Zadanie: " + this.id + " nie posiada opisu!" );
        return "";
    }

    public String getId()
    {
        return parentNode.getId() + "_ACTIVITY(" + this.id + ")";
    }

    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();

        NodeList extendedAttrs = getExtendedAttributes();
        for ( ExtendedAttribute actionButton : getActionButtons( extendedAttrs ) )
        {
            map.putAll( actionButton.getProperties() );
        }

        for ( HttpLinkAttr httpLink : getHttpLinks( extendedAttrs ) )
        {
            map.putAll( httpLink.getProperties() );
        }

        for ( VariableSetAttr variableSet : getVariableSets( extendedAttrs ) )
        {
            map.putAll( variableSet.getProperties() );
        }

        map.put( parentNode.getId() + "_ACTIVITY(" + this.id + ")_DESC", getDescription() );

        return map;
    }

    public List<VariableSetAttr> getVariableSets( NodeList extendedAttrs )
    {
        List<VariableSetAttr> variableSets = new ArrayList<VariableSetAttr>();

        int nr = 0;

        Map<String, List<DtButtonAttr>> dtButtons = getDtButtons( extendedAttrs );
        for ( int j = 0; j < extendedAttrs.getLength(); j++ )
        {
            Node extendedAttr = extendedAttrs.item( j );
            try
            {
                NamedNodeMap attributes = extendedAttr.getAttributes();
                if ( attributes == null )
                {
                    continue;
                }
                String name = attributes.getNamedItem( "Name" ).toString();
                name = splitValue( name );
                if ( name.matches( "VARIABLE_SET(|_VIEW)" ) )
                {
                    VariableSetAttr variableSet = new VariableSetAttr( extendedAttr, this, nr++ );
                    variableSet.setDtButtons( dtButtons.get( variableSet.getTableId() ) );
                    variableSets.add( variableSet );
                }
            }
            catch ( Exception e )
            {
                log.error( "Błąd podczas odczytu tabeli dynamicznej", e );
            }
        }

        return variableSets;
    }

    private List<ExtendedAttribute> getActionButtons( NodeList extendedAttrs )
    {
        List<ExtendedAttribute> actionButtons = new ArrayList<ExtendedAttribute>();

        for ( int j = 0; j < extendedAttrs.getLength(); j++ )
        {
            Node extendedAttr = extendedAttrs.item( j );
            try
            {
                String name = extendedAttr.getAttributes().getNamedItem( "Name" ).toString();
                name = splitValue( name );
                if ( name.equals( "ACTION_ACCEPT_BUTTON" ) )
                {
                    actionButtons.add( new ActionButtonAttr( extendedAttr, this ) );
                }
                else if ( name.equals( "GENERATE_PDF_BUTTON" ) )
                {
                    actionButtons.add( new PdfButtonAttr( extendedAttr, this ) );
                }
                else if ( name.equals( "ADD_FILE_BUTTON" ) )
                {
                    actionButtons.add( new AddFileButtonAttr( extendedAttr, this ) );
                }

            }
            catch ( NullPointerException npe )
            {
                // log.warn( "Smth goes wrong" );
            }
        }
        return actionButtons;
    }

    private Map<String, List<DtButtonAttr>> getDtButtons( NodeList extendedAttrs )
    {
        Map<String, List<DtButtonAttr>> dtButtons = new HashMap<String, List<DtButtonAttr>>();

        for ( int j = 0; j < extendedAttrs.getLength(); j++ )
        {
            Node extendedAttr = extendedAttrs.item( j );
            try
            {
                String name = extendedAttr.getAttributes().getNamedItem( "Name" ).toString();
                name = splitValue( name );
                if ( name.equals( "DT_BUTTON" ) )
                {
                    DtButtonAttr dtButton = new DtButtonAttr( extendedAttr, this );
                    if ( !dtButtons.containsKey( dtButton.getVariableSetId() ) )
                    {
                        dtButtons.put( dtButton.getVariableSetId(), new ArrayList<DtButtonAttr>() );
                    }
                    dtButtons.get( dtButton.getVariableSetId() ).add( dtButton );
                }
            }
            catch ( NullPointerException npe )
            {
                // log.warn( "Smth goes wrong" );
            }
        }
        return dtButtons;
    }

    private List<HttpLinkAttr> getHttpLinks( NodeList extendedAttrs )
    {
        List<HttpLinkAttr> httpLinks = new ArrayList<HttpLinkAttr>();

        for ( int j = 0; j < extendedAttrs.getLength(); j++ )
        {
            Node extendedAttr = extendedAttrs.item( j );
            try
            {
                String name = extendedAttr.getAttributes().getNamedItem( "Name" ).toString();
                name = splitValue( name );
                if ( name.equals( "HTTP_LINK" ) )
                {
                    httpLinks.add( new HttpLinkAttr( extendedAttr, this ) );
                }
            }
            catch ( NullPointerException npe )
            {
                // log.warn( "Smth goes wrong" );
            }
        }
        return httpLinks;
    }
}
