/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.suncode.pwfl.i18n.xpdl.PackageVersion;
import com.suncode.pwfl.i18n.xpdl.helper.Property;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TranslationWriter {
    private static final Logger log = LoggerFactory.getLogger(TranslationWriter.class);

    public void write(List<Property> properties, File file) {
        String resultFileContent = this.generateFileContent(properties);
        FileUtils.forceMkdir((File)file.getParentFile());
        FileUtils.writeStringToFile((File)file, (String)resultFileContent, (Charset)StandardCharsets.UTF_8);
    }

    private String generateFileContent(List<Property> properties) {
        StringBuilder builder = new StringBuilder();
        this.addPackageProperties(builder, properties);
        this.addUnknownPackageProperties(builder, properties);
        return builder.toString().trim();
    }

    private void addPackageProperties(StringBuilder builder, List<Property> properties) {
        Map packageVersionToProperties = properties.stream().filter(property -> property.getPackageVersion().isPresent()).sorted(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).collect(Collectors.groupingBy(property -> property.getPackageVersion().get(), LinkedHashMap::new, Collectors.toList()));
        packageVersionToProperties.forEach((packageVersion, propertiesForPackage) -> {
            if (!propertiesForPackage.isEmpty()) {
                this.buildPackageComment(builder, (PackageVersion)packageVersion);
                this.breakLine(builder);
                propertiesForPackage.forEach(property -> {
                    property.buildString(builder);
                    this.breakLine(builder);
                });
                this.breakLine(builder);
            }
        });
    }

    private void buildPackageComment(StringBuilder builder, PackageVersion packageVersion) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        builder.append("# ").append("Package: ").append(packageVersion.getId()).append(", Version: ").append(packageVersion.getVersion()).append(", Export date: ").append(format.format(packageVersion.getExportDate()));
    }

    private void addUnknownPackageProperties(StringBuilder builder, List<Property> properties) {
        List<Property> unknownPackageProperties = this.findUnknownPackageProperties(properties);
        if (!unknownPackageProperties.isEmpty()) {
            this.buildUnknownComment(builder);
            this.breakLine(builder);
            unknownPackageProperties.forEach(property -> {
                property.buildString(builder);
                this.breakLine(builder);
            });
        }
    }

    private List<Property> findUnknownPackageProperties(List<Property> properties) {
        return properties.stream().filter(property -> !property.getPackageVersion().isPresent()).sorted(Comparator.comparing(Property::getValue)).collect(Collectors.toList());
    }

    private void buildUnknownComment(StringBuilder builder) {
        builder.append("# Unknown");
    }

    private void breakLine(StringBuilder builder) {
        builder.append("\r\n");
    }
}

