/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.i18n;

import com.plusmpm.i18n.AbstractI18N;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18NCustom
extends AbstractI18N {
    private static final Logger log = LoggerFactory.getLogger(I18NCustom.class);
    private static Function<Locale, ResourceBundle> BUNDLE_FUNCTION = null;

    public I18NCustom() {
    }

    public I18NCustom(Locale locale) {
        super(locale);
    }

    @Deprecated(since="4.2", forRemoval=true)
    public I18NCustom(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    @Override
    public String getString(String sKey) {
        String transformedKey = null;
        try {
            transformedKey = this.getAsProperty(sKey);
            return this.bundle.getString(transformedKey);
        }
        catch (MissingResourceException mre) {
            log.info("Brak tekstu dla klucza: [" + transformedKey + "]. Wersja j\u0119zykowa: " + this.getLang());
        }
        catch (ClassCastException cce) {
            log.error("Warto\u015b\u0107 dla klucza: [" + transformedKey + "] nie jest typu java.lang.String. Wersja j\u0119zykowa: " + this.getLang(), (Throwable)cce);
        }
        catch (NullPointerException npe) {
            log.info("Warto\u015b\u0107 klucza jest nullem");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sKey;
    }

    public String tryGetString(String sKey) throws MissingResourceException {
        String transformedKey = null;
        try {
            transformedKey = this.getAsProperty(sKey);
            return this.bundle.getString(transformedKey);
        }
        catch (MissingResourceException mre) {
            throw mre;
        }
        catch (ClassCastException cce) {
            log.error("Warto\u015b\u0107 dla klucza: [" + transformedKey + "] nie jest typu java.lang.String. Wersja j\u0119zykowa: " + this.getLang(), (Throwable)cce);
        }
        catch (NullPointerException npe) {
            log.info("Warto\u015b\u0107 klucza jest nullem");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sKey;
    }

    @Override
    public String getStringSilent(String key) {
        try {
            String transformedKey = this.getAsProperty(key);
            return this.bundle.getString(transformedKey);
        }
        catch (Exception exception) {
            return key;
        }
    }

    private String getAsProperty(String name) {
        name = name.trim().replaceAll("[ \t=:]+", "_");
        return name;
    }

    @Override
    public void populateBundle() {
        this.bundle = BUNDLE_FUNCTION.apply(this.locale);
    }

    public static void provideBundleFunction(Function<Locale, ResourceBundle> bundleFunction) {
        BUNDLE_FUNCTION = bundleFunction;
    }
}

