/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.i18n;

import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.i18n.CustomControlI18N;
import com.suncode.pwfl.i18n.xpdl.TranslationUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18Nxpdl
extends AbstractI18N {
    public static final Logger log = Logger.getLogger(I18Nxpdl.class);
    public static String PATH_TO_XPDL_BUNDLE;
    public static final String S_BUNDLE_BASE_NAME = "xpdlMessages";
    private static final Set<Locale> xpdlLocales;

    public I18Nxpdl() {
    }

    public static void initialize(String pathToXpdlBundle) throws Exception {
        PATH_TO_XPDL_BUNDLE = pathToXpdlBundle;
        TranslationUtils.updateTranslation(false);
        I18Nxpdl.readXpdlLocales();
    }

    public I18Nxpdl(Locale locale) {
        super(locale);
    }

    @Deprecated(since="4.2", forRemoval=true)
    public I18Nxpdl(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    public static Set<Locale> getXpdlLocales() {
        return xpdlLocales;
    }

    public static Locale getValidXpdlLocale() {
        return LocaleContextHolder.getLocale();
    }

    private static void readXpdlLocales() {
        File[] bundles;
        File pathToBundle = new File(PATH_TO_XPDL_BUNDLE);
        for (File bundle : bundles = pathToBundle.listFiles(new BundleFilenameFilter())) {
            String name = bundle.getName();
            if (name.length() <= S_BUNDLE_BASE_NAME.length() + ".i18n".length()) {
                xpdlLocales.add(new Locale("pl"));
                continue;
            }
            String locale = name.substring(S_BUNDLE_BASE_NAME.length() + 1, name.length() - ".i18n".length());
            xpdlLocales.add(new Locale(locale));
        }
    }

    @Override
    public String getString(String sKey) {
        String transformedKey = null;
        try {
            transformedKey = this.getAsProperty(sKey);
            String ret = this.bundle.getString(transformedKey).trim();
            return ret;
        }
        catch (MissingResourceException mre) {
            log.error((Object)("Brak tekstu dla klucza: [" + sKey + "]. Wersja j\u0119zykowa: " + this.getLang()), (Throwable)mre);
        }
        catch (ClassCastException cce) {
            log.error((Object)("Warto\u015b\u0107 dla klucza: [" + sKey + "] nie jest typu java.lang.String. Wersja j\u0119zykowa: " + this.getLang()), (Throwable)cce);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sKey;
    }

    @Override
    public String getStringSilent(String key) {
        String transformedKey = null;
        try {
            transformedKey = this.getAsProperty(key);
            String ret = this.bundle.getString(transformedKey).trim();
            return ret;
        }
        catch (Exception exception) {
            return key;
        }
    }

    public String getString(String opt1, String opt2) {
        String ret;
        String transformedKey1 = null;
        String transformedKey2 = null;
        try {
            transformedKey1 = this.getAsProperty(opt1);
            transformedKey2 = this.getAsProperty(opt2);
            ret = this.bundle.getString(transformedKey1).trim();
        }
        catch (MissingResourceException mre) {
            ret = this.getString(transformedKey2);
        }
        catch (NullPointerException npe) {
            ret = this.getString(transformedKey2);
        }
        return ret;
    }

    public String getStringWithDefault(String opt1, String defaultString) {
        String ret;
        String transformedKey1 = null;
        try {
            transformedKey1 = this.getAsProperty(opt1);
            ret = this.bundle.getString(transformedKey1).trim();
        }
        catch (MissingResourceException mre) {
            ret = new String(defaultString);
        }
        catch (NullPointerException npe) {
            ret = new String(defaultString);
        }
        return ret;
    }

    public String getStringWithDefault(String opt1, String opt2, String defaultString) {
        String ret;
        String transformedKey1 = null;
        try {
            transformedKey1 = this.getAsProperty(opt1);
            ret = this.bundle.getString(transformedKey1).trim();
        }
        catch (MissingResourceException mre) {
            ret = this.getStringWithDefault(opt2, defaultString);
        }
        catch (NullPointerException npe) {
            ret = this.getStringWithDefault(opt2, defaultString);
        }
        return ret;
    }

    private String getAsProperty(String name) {
        name = name.replaceAll("[ \t]+", "_");
        return name;
    }

    @Override
    public void populateBundle() {
        this.bundle = ResourceBundle.getBundle(S_BUNDLE_BASE_NAME, this.locale, new CustomControlI18N(PATH_TO_XPDL_BUNDLE));
    }

    static {
        xpdlLocales = new HashSet<Locale>();
    }

    static class BundleFilenameFilter
    implements FilenameFilter {
        BundleFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(I18Nxpdl.S_BUNDLE_BASE_NAME) && name.endsWith(".i18n");
        }
    }
}

