/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.i18n;

import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.i18n.CustomControlI18N;
import com.suncode.pwfl.i18n.xpdl.TranslationUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18NCustom
extends AbstractI18N {
    private static final Logger log = LoggerFactory.getLogger(I18NCustom.class);
    private static String PATH_TO_CUSTOM_BUNDLE;
    public static final String S_BUNDLE_BASE_NAME = "customMessages";
    private static boolean initilized;

    public I18NCustom() {
    }

    public static void initialize(String pathToCustomBundle) throws Exception {
        if (StringUtils.isNotEmpty((String)pathToCustomBundle)) {
            try {
                TranslationUtils.updateCustomTranslation(pathToCustomBundle);
                initilized = true;
            }
            catch (IOException e) {
                log.error("Could not create custom translation file in path {}", (Object)pathToCustomBundle, (Object)e);
            }
        }
        PATH_TO_CUSTOM_BUNDLE = pathToCustomBundle;
    }

    public I18NCustom(Locale locale) {
        super(locale);
    }

    public I18NCustom(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    @Override
    public String getString(String sKey) {
        if (initilized) {
            String transformedKey = null;
            try {
                transformedKey = this.getAsProperty(sKey);
                return this.bundle.getString(transformedKey);
            }
            catch (MissingResourceException mre) {
                log.info("Brak tekstu dla klucza: [" + transformedKey + "]. Wersja j\u0119zykowa: " + this.getLang());
            }
            catch (ClassCastException cce) {
                log.error("Warto\u015b\u0107 dla klucza: [" + transformedKey + "] nie jest typu java.lang.String. Wersja j\u0119zykowa: " + this.getLang(), (Throwable)cce);
            }
            catch (NullPointerException npe) {
                log.info("Warto\u015b\u0107 klucza jest nullem");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return sKey;
        }
        return sKey;
    }

    public String tryGetString(String sKey) throws MissingResourceException {
        if (initilized) {
            String transformedKey = null;
            try {
                transformedKey = this.getAsProperty(sKey);
                return this.bundle.getString(transformedKey);
            }
            catch (MissingResourceException mre) {
                throw mre;
            }
            catch (ClassCastException cce) {
                log.error("Warto\u015b\u0107 dla klucza: [" + transformedKey + "] nie jest typu java.lang.String. Wersja j\u0119zykowa: " + this.getLang(), (Throwable)cce);
            }
            catch (NullPointerException npe) {
                log.info("Warto\u015b\u0107 klucza jest nullem");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return sKey;
        }
        return sKey;
    }

    @Override
    public String getStringSilent(String key) {
        if (initilized) {
            String transformedKey = null;
            try {
                transformedKey = this.getAsProperty(key);
                return this.bundle.getString(transformedKey);
            }
            catch (Exception exception) {
                return key;
            }
        }
        return key;
    }

    private String getAsProperty(String name) {
        name = name.replaceAll("[ \t=:]+", "_");
        return name;
    }

    @Override
    public void populateBundle() {
        if (initilized) {
            this.bundle = ResourceBundle.getBundle(S_BUNDLE_BASE_NAME, this.locale, new CustomControlI18N(PATH_TO_CUSTOM_BUNDLE));
        }
    }
}

