/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n;

import com.suncode.pwfl.i18n.MessageHelperBean;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Component;

@Component
public class MessageHelper {
    private static MessageHelper instance;
    private static MessageHelperBean bean;

    @Autowired
    public void setBean(MessageHelperBean bean) {
        MessageHelper.bean = bean;
    }

    private MessageHelper() {
        instance = this;
    }

    public static MessageHelper getInstance() {
        return instance;
    }

    public MessageSource getMessageSource() {
        return bean.getMessageSource();
    }

    public MessageSourceAccessor getMessageSourceAccessor() {
        return bean.getMessageSourceAccessor();
    }

    public static String getMessage(String code) {
        return bean.getMessage(code);
    }

    public static String getMessage(String code, Object ... args) {
        return bean.getMessage(code, args);
    }

    public static String getMessage(String code, Locale locale, Object ... args) {
        return bean.getMessage(code, args, locale);
    }

    public static String getOptionalMessage(String code) {
        try {
            return bean.getMessage(code);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }

    public static String getOptionalMessage(String code, Object ... args) {
        try {
            return bean.getMessage(code, args);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }

    public static String getOptionalMessage(String code, Locale locale, Object ... args) {
        try {
            return bean.getMessage(code, args, locale);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }
}

