/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n;

import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Component;

@Component
public class MessageHelper {
    private static MessageHelper instance;
    private MessageSource messageSource;
    private MessageSourceAccessor messageSourceAccessor;

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    private MessageHelper() {
        instance = this;
    }

    public static MessageHelper getInstance() {
        return instance;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public MessageSourceAccessor getMessageSourceAccessor() {
        return this.messageSourceAccessor;
    }

    public static String getMessage(String code) {
        return MessageHelper.getInstance().getMessageSourceAccessor().getMessage(code);
    }

    public static String getMessage(String code, Object ... args) {
        return MessageHelper.getInstance().getMessageSourceAccessor().getMessage(code, args);
    }

    public static String getMessage(String code, Locale locale, Object ... args) {
        return MessageHelper.getInstance().getMessageSourceAccessor().getMessage(code, args, locale);
    }

    public static String getOptionalMessage(String code) {
        try {
            return MessageHelper.getInstance().getMessageSourceAccessor().getMessage(code);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }

    public static String getOptionalMessage(String code, Object ... args) {
        try {
            return MessageHelper.getInstance().getMessageSourceAccessor().getMessage(code, args);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }

    public static String getOptionalMessage(String code, Locale locale, Object ... args) {
        try {
            return MessageHelper.getInstance().getMessageSourceAccessor().getMessage(code, args, locale);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }
}

