/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.suncode.pwfl.i18n.xpdl.ExportDateProvider;
import com.suncode.pwfl.i18n.xpdl.PackageVersion;
import com.suncode.pwfl.i18n.xpdl.helper.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TranslationOverrider {
    private static final Logger log = LoggerFactory.getLogger(TranslationOverrider.class);
    @Autowired
    private ExportDateProvider exportDateProvider;

    public List<Property> overrideTranslations(List<Property> properties, File bundle, Boolean packageWasUpdated, Map<String, String> additionalTranslations) throws IOException {
        List<Property> propertiesSnapshot = this.copy(properties);
        if (bundle.exists()) {
            Date latestExport = this.exportDateProvider.getLatestExportDate();
            this.overrideBundleProperties(bundle, propertiesSnapshot, packageWasUpdated, latestExport);
            this.overrideAdditionalTranslations(propertiesSnapshot, additionalTranslations, packageWasUpdated, latestExport);
            this.addCommentedBundleProperties(bundle, propertiesSnapshot);
            this.filterProperties(propertiesSnapshot);
        }
        return propertiesSnapshot;
    }

    private void overrideBundleProperties(File bundle, List<Property> propertiesSnapshot, Boolean packageWasUpdated, Date latestExport) throws IOException {
        Multimap<String, String> bundleProperties = this.loadPropertiesMap(bundle);
        this.overrideProperties(propertiesSnapshot, packageWasUpdated, latestExport, bundleProperties);
    }

    private void overrideAdditionalTranslations(List<Property> propertiesSnapshot, Map<String, String> additionalTranslations, Boolean packageWasUpdated, Date latestExport) {
        HashMultimap additionalTranslationsMultimap = HashMultimap.create();
        additionalTranslations.forEach((arg_0, arg_1) -> ((Multimap)additionalTranslationsMultimap).put(arg_0, arg_1));
        this.overrideProperties(propertiesSnapshot, packageWasUpdated, latestExport, (Multimap<String, String>)additionalTranslationsMultimap);
    }

    private void overrideProperties(List<Property> propertiesSnapshot, Boolean packageWasUpdated, Date latestExport, Multimap<String, String> overrideProperties) {
        this.forEach(overrideProperties, (key, keyValue) -> {
            String value = StringUtils.defaultString((String)keyValue);
            if (this.contains(propertiesSnapshot, (String)key)) {
                List<Property> toOverride = this.findToOverride(propertiesSnapshot, (String)key, value, latestExport, packageWasUpdated);
                if (!toOverride.isEmpty()) {
                    toOverride.forEach(property -> property.setValue(value));
                } else if (!this.contains(propertiesSnapshot, (String)key, value)) {
                    this.findByKey(propertiesSnapshot, (String)key).stream().max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(property -> {
                        Property bundleProperty = this.snapshotProperty((Property)property, value, true);
                        this.addBundleProperty(propertiesSnapshot, (Property)property, bundleProperty, false);
                    });
                }
            } else {
                this.addUnknownPackageProperty(propertiesSnapshot, (String)key, value, false);
            }
        });
    }

    public Multimap<String, String> loadPropertiesMap(File propertiesFile) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
            Properties properties = new Properties();
            properties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            HashMultimap result = HashMultimap.create();
            properties.entrySet().forEach(arg_0 -> TranslationOverrider.lambda$loadPropertiesMap$4((Multimap)result, arg_0));
            HashMultimap hashMultimap = result;
            return hashMultimap;
        }
    }

    private Multimap<String, String> loadCommentedPropertiesMap(File propertiesFile) throws IOException {
        HashMultimap result = HashMultimap.create();
        Files.lines(propertiesFile.toPath()).filter(line -> line.matches("\\s*#\\s*[^= :]*=[^=]*$")).map(line -> line.replaceFirst("#", "")).map(line -> line.split("=", -1)).forEach(arg_0 -> TranslationOverrider.lambda$loadCommentedPropertiesMap$8((Multimap)result, arg_0));
        return result;
    }

    private List<Property> findToOverride(List<Property> propertiesSnapshot, String key, String value, Date latestExport, Boolean packageWasUpdated) {
        return this.findByKey(propertiesSnapshot, key).stream().filter(property -> !property.getValue().equals(value)).filter(property -> property.getCommented() == false).filter(property -> packageWasUpdated == false || !this.exportDateMatches((Property)property, latestExport)).collect(Collectors.toList());
    }

    private void addCommentedBundleProperties(File bundle, List<Property> propertiesSnapshot) throws IOException {
        Multimap<String, String> commentedBundleProperties = this.loadCommentedPropertiesMap(bundle);
        LinkedList propertiesToAdd = new LinkedList();
        this.forEach(commentedBundleProperties, (key, value) -> {
            List<Property> sameKeyProperties = this.findByKey(propertiesSnapshot, (String)key);
            if (!sameKeyProperties.isEmpty()) {
                if (!this.contains(propertiesSnapshot, (String)key, (String)value)) {
                    sameKeyProperties.stream().filter(property -> property.getPackageVersion().isPresent()).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(property -> {
                        Property snapshotProperty = this.snapshotProperty((Property)property, (String)value, true);
                        propertiesToAdd.add(snapshotProperty);
                    });
                }
            } else {
                this.addUnknownPackageProperty(propertiesSnapshot, (String)key, (String)value, true);
            }
        });
        propertiesToAdd.forEach(newProperty -> {
            if (newProperty.getPackageVersion().isPresent()) {
                propertiesSnapshot.stream().filter(property -> property.getPackageVersion().isPresent()).filter(property -> property.getKey().equals(newProperty.getKey())).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(lastUncommentedProperty -> this.addBundleProperty(propertiesSnapshot, (Property)lastUncommentedProperty, (Property)newProperty, false));
            } else {
                propertiesSnapshot.add((Property)newProperty);
            }
        });
    }

    private void filterProperties(List<Property> properties) {
        List filteredProperties = properties.stream().filter(this.isNotBlank()).filter(this.distinctByKey(property -> property.hashCodeAll())).collect(Collectors.toList());
        properties.clear();
        properties.addAll(filteredProperties);
    }

    public <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public Predicate<Property> isNotBlank() {
        return p -> StringUtils.isNotBlank((String)p.getValue());
    }

    private List<Property> copy(List<Property> properties) {
        return properties.stream().map(Property::snapshot).collect(Collectors.toList());
    }

    private List<Property> findByKey(List<Property> propertiesSnapshot, String key) {
        return propertiesSnapshot.stream().filter(property -> property.getKey().equals(key)).collect(Collectors.toList());
    }

    private boolean contains(List<Property> properties, String key) {
        return !this.findByKey(properties, key).isEmpty();
    }

    private boolean contains(List<Property> properties, String key, String value) {
        return !this.findByKeyAndValue(properties, key, value).isEmpty();
    }

    private List<Property> findByKeyAndValue(List<Property> properties, String key, String value) {
        return this.findByKey(properties, key).stream().filter(property -> property.getValue().equals(value)).collect(Collectors.toList());
    }

    private Property snapshotProperty(Property property, String value, Boolean commented) {
        Property bundleProperty = property.snapshot();
        bundleProperty.setValue(value);
        bundleProperty.setCommented(commented);
        return bundleProperty;
    }

    private void addBundleProperty(List<Property> propertiesSnapshot, Property propertyPlacement, Property bundleProperty, Boolean after) {
        int index = propertiesSnapshot.indexOf(propertyPlacement);
        if (index >= 0) {
            propertiesSnapshot.add(after != false ? index + 1 : index, bundleProperty);
        } else {
            log.warn("Cannot find index of property " + propertyPlacement.getKey());
            propertiesSnapshot.add(bundleProperty);
        }
    }

    private void addUnknownPackageProperty(List<Property> propertiesSnapshot, String key, String value, Boolean commented) {
        Property unknownPackageProperty = new Property(key, value, Optional.empty());
        unknownPackageProperty.setCommented(commented);
        propertiesSnapshot.add(unknownPackageProperty);
    }

    private boolean exportDateMatches(Property property, Date date) {
        Optional<PackageVersion> optionalPackageVersion = property.getPackageVersion();
        if (optionalPackageVersion.isPresent()) {
            Date exportDate = optionalPackageVersion.get().getExportDate();
            return exportDate.equals(date);
        }
        return false;
    }

    private <T, K> void forEach(Multimap<T, K> multimap, BiConsumer<T, K> consumer) {
        multimap.keySet().forEach(key -> multimap.get(key).forEach(value -> consumer.accept(key, value)));
    }

    private static /* synthetic */ void lambda$loadCommentedPropertiesMap$8(Multimap result, String[] array) {
        result.put((Object)array[0].trim(), (Object)array[1].trim());
    }

    private static /* synthetic */ void lambda$loadPropertiesMap$4(Multimap result, Map.Entry prop) {
        result.put((Object)prop.getKey().toString(), (Object)prop.getValue().toString());
    }
}

