/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.i18n.utils.SpringI18NUtils;
import com.suncode.pwfl.i18n.xpdl.ExportDateProvider;
import com.suncode.pwfl.i18n.xpdl.PackageVersion;
import com.suncode.pwfl.i18n.xpdl.TranslationOverrider;
import com.suncode.pwfl.i18n.xpdl.TranslationResolver;
import com.suncode.pwfl.i18n.xpdl.TranslationWriter;
import com.suncode.pwfl.i18n.xpdl.helper.Property;
import java.io.File;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.enhydra.shark.Shark;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TranslationUtils {
    private static final Logger log = LoggerFactory.getLogger(TranslationUtils.class);
    private static ExportDateProvider exportDateProvider = (ExportDateProvider)SpringI18NUtils.getContext().getBean(ExportDateProvider.class);
    private static TranslationResolver translationResolver = (TranslationResolver)SpringI18NUtils.getContext().getBean(TranslationResolver.class);
    private static TranslationWriter translationWriter = (TranslationWriter)SpringI18NUtils.getContext().getBean(TranslationWriter.class);
    private static TranslationOverrider translationOverrider = (TranslationOverrider)SpringI18NUtils.getContext().getBean(TranslationOverrider.class);

    public static void createTranslation() throws Exception {
        TranslationUtils.update(false, true);
    }

    public static void updateTranslation() throws Exception {
        TranslationUtils.update(true, true);
    }

    public static void updateTranslation(Boolean packageWasUpdated) throws Exception {
        TranslationUtils.update(true, packageWasUpdated);
    }

    private static void update(Boolean runIfFileExists, Boolean packageWasUpdated) throws Exception {
        List<Property> translations = TranslationUtils.getTranslations();
        File defaultTranslationFile = TranslationUtils.getDefaultTranslationFile();
        if (runIfFileExists.booleanValue() || !defaultTranslationFile.exists()) {
            translationWriter.write(translations, defaultTranslationFile);
        }
        for (File file : TranslationUtils.getSupportedTranslationsFiles()) {
            if (!runIfFileExists.booleanValue() && file.exists()) continue;
            List<Property> overrideTranslations = translationOverrider.overrideTranslations(translations, file, packageWasUpdated);
            translationWriter.write(overrideTranslations, file);
        }
        AbstractI18N.refresh();
    }

    private static List<Property> getTranslations() throws Exception {
        RepositoryPersistenceManager repositoryManager = TranslationUtils.getRepositoryManagerByReflection();
        RepositoryTransaction transaction = Shark.getInstance().createRepositoryTransaction();
        try {
            List<PackageVersion> packageVersions = TranslationUtils.getPackageVersions(repositoryManager, transaction);
            transaction.commit();
            List<Property> list = translationResolver.loadTranslations(packageVersions);
            return list;
        }
        catch (Error e) {
            log.error(e.getMessage(), (Throwable)e);
            TranslationUtils.rollbackTransaction(transaction, e);
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            TranslationUtils.rollbackTransaction(transaction, e);
            throw e;
        }
        finally {
            transaction.release();
        }
    }

    private static List<PackageVersion> getPackageVersions(RepositoryPersistenceManager repositoryManager, RepositoryTransaction transaction) throws RepositoryException {
        LinkedList<PackageVersion> packageVersions = new LinkedList<PackageVersion>();
        for (String packageId : repositoryManager.getExistingXPDLIds(transaction)) {
            for (String version : repositoryManager.getXPDLVersions(transaction, packageId)) {
                packageVersions.add(new PackageVersion(packageId, Long.parseLong(version)));
            }
        }
        exportDateProvider.fillExportDateData(packageVersions);
        return packageVersions;
    }

    private static File getDefaultTranslationFile() {
        return new File(I18Nxpdl.PATH_TO_XPDL_BUNDLE + "/" + "xpdlMessages" + ".i18n");
    }

    private static List<File> getSupportedTranslationsFiles() {
        return AbstractI18N.getSupportedLocales().stream().map(locale -> I18Nxpdl.PATH_TO_XPDL_BUNDLE + "/" + "xpdlMessages" + "_" + locale.getLanguage() + ".i18n").map(File::new).collect(Collectors.toList());
    }

    private static void rollbackTransaction(RepositoryTransaction transaction, Throwable ex) throws TransactionException {
        try {
            transaction.rollback();
        }
        catch (TransactionException transactionException) {
            log.error("Rollback transakcji zako\u0144czony b\u0142\u0119dem. Pow\u00f3d dla kt\u00f3rego przeprowadzany jest rollback: ", ex);
            throw transactionException;
        }
    }

    private static RepositoryPersistenceManager getRepositoryManagerByReflection() {
        try {
            Method getInstance = SharkEngineManager.class.getDeclaredMethod("getInstance", new Class[0]);
            Method getRepositoryPersistenceManager = SharkEngineManager.class.getDeclaredMethod("getRepositoryPersistenceManager", new Class[0]);
            getInstance.setAccessible(true);
            getRepositoryPersistenceManager.setAccessible(true);
            SharkEngineManager engineManager = (SharkEngineManager)getInstance.invoke(null, new Object[0]);
            return (RepositoryPersistenceManager)getRepositoryPersistenceManager.invoke((Object)engineManager, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Nie uda\u0142o si\u0119 pobra\u0107 obiektu [" + RepositoryPersistenceManager.class + "] przez refleksj\u0119", ex);
        }
    }
}

