/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.suncode.pwfl.i18n.xpdl.PackageVersion;
import com.suncode.pwfl.i18n.xpdl.helper.Property;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TranslationWriter {
    private static final Logger log = LoggerFactory.getLogger(TranslationWriter.class);

    public void write(List<Property> properties, File file) {
        String resultFileContent = this.generateFileContent(properties);
        FileUtils.forceMkdir((File)file.getParentFile());
        FileUtils.writeStringToFile((File)file, (String)resultFileContent, (Charset)StandardCharsets.UTF_8);
    }

    private String generateFileContent(List<Property> properties) {
        StringBuilder builder = new StringBuilder();
        this.getSortedPackages(properties).forEach(packageVersion -> {
            List<Property> propertiesForPackage = properties.stream().filter(property -> property.getPackageVersion().equals(packageVersion)).collect(Collectors.toList());
            if (!propertiesForPackage.isEmpty()) {
                this.buildPackageComment(builder, (PackageVersion)packageVersion);
                this.breakLine(builder);
                propertiesForPackage.forEach(property -> {
                    property.buildString(builder);
                    this.breakLine(builder);
                });
                this.breakLine(builder);
            }
        });
        return builder.toString().trim();
    }

    private List<PackageVersion> getSortedPackages(List<Property> properties) {
        return properties.stream().map(Property::getPackageVersion).distinct().sorted(Comparator.comparing(PackageVersion::getExportDate)).collect(Collectors.toList());
    }

    private void breakLine(StringBuilder builder) {
        builder.append("\r\n");
    }

    private void buildPackageComment(StringBuilder builder, PackageVersion packageVersion) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        builder.append("# ").append("Package: ").append(packageVersion.getId()).append(", Version: ").append(packageVersion.getVersion()).append(", Export date: ").append(format.format(packageVersion.getExportDate()));
    }
}

