/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.i18n;

import com.suncode.pwfl.i18n.utils.SpringI18NUtils;
import com.suncode.pwfl.i18n.utils.SupportedLanguagesProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class AbstractI18N {
    private static final Logger log = LoggerFactory.getLogger(AbstractI18N.class);
    protected Locale locale;
    protected ResourceBundle bundle;

    public AbstractI18N() {
        log.trace("Ustawiam domy\u015bln\u0105 lokalizacj\u0119 u\u017cytkownika...");
        this.locale = Locale.getDefault();
        log.trace("Ustawiono: " + this.locale.getLanguage());
        this.populateBundle();
    }

    public AbstractI18N(Locale locale) {
        log.trace("Ustawiam lokalizacj\u0119 u\u017cytkownika...");
        this.locale = locale;
        log.trace("Ustawiono: " + locale.getLanguage());
        this.populateBundle();
    }

    public AbstractI18N(HttpServletRequest request) {
        log.trace("Ustawiam lokalizacj\u0119 u\u017cytkownika, sprawdzaj\u0105c czy ma w sesji zapisane obiekt ustawie\u0144 j\u0119zykowych...");
        this.locale = AbstractI18N.getLocale(request);
        log.trace("Ustawiono: " + this.locale.getLanguage());
        this.populateBundle();
    }

    public static Locale getFromBrowserSettings(HttpServletRequest httpServletRequest) {
        log.debug("Pobieram ustawienia j\u0119zykowe z ustawie\u0144 przegl\u0105darki");
        Enumeration enumLocales = httpServletRequest.getLocales();
        Locale locale = (Locale)enumLocales.nextElement();
        log.debug("Pobrano: " + locale.getLanguage());
        return locale;
    }

    public static Locale getFromUserSettings(String username) {
        log.debug("Pobieram ustawienia j\u0119zykowe z ustawie\u0144 u\u017cytkownika");
        return Locale.getDefault();
    }

    public static List<Locale> getSupportedLocales() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        SupportedLanguagesProvider provider = (SupportedLanguagesProvider)SpringI18NUtils.getContext().getBean(SupportedLanguagesProvider.class);
        String supportedLocalesParam = provider.getSupportedLocalesParam();
        for (String localeLang : supportedLocalesParam.split(";")) {
            supportedLocales.add(new Locale(localeLang));
        }
        return supportedLocales;
    }

    public static boolean isLocaleSupported(Locale locale) {
        String lang = locale.getLanguage();
        return AbstractI18N.getSupportedLocales().contains(new Locale(lang));
    }

    @Deprecated
    public static Locale getLocale(HttpServletRequest request) {
        return LocaleContextHolder.getLocale();
    }

    public static void setSessionLocale(HttpSession session, String localeName) {
        log.debug("Ustawiam w sesji ustawienia jezykowe uzytkownika na " + localeName);
        Locale locale = null;
        if (!localeName.equals("default")) {
            locale = new Locale(localeName);
        }
        session.setAttribute("org.apache.struts.action.LOCALE", locale);
    }

    public static void removeSessionLocale(HttpSession session) {
        log.debug("Usuwam z sesji ustawienia jezykowe uzytkownika");
        session.removeAttribute("org.apache.struts.action.LOCALE");
    }

    public String getLang() {
        return this.locale.getLanguage();
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public static void refresh() {
        log.debug("Odwiezam paczke zasob\u00f3w");
        ResourceBundle.clearCache();
    }

    public abstract void populateBundle();

    public abstract String getString(String var1);

    public abstract String getStringSilent(String var1);

    public String getStringOrDefault(String key, String defaultValue) {
        if (this.bundle != null && this.bundle.containsKey(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }
}

