/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.suncode.pwfl.i18n.xpdl.PackageVersion;
import com.suncode.pwfl.i18n.xpdl.TranslationProvider;
import com.suncode.pwfl.i18n.xpdl.helper.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TranslationResolver {
    private static final Logger log = LoggerFactory.getLogger(TranslationResolver.class);
    @Autowired
    private TranslationProvider translationProvider;

    public List<Property> loadTranslations(List<PackageVersion> packageVersions) {
        Map<PackageVersion, Map<String, String>> updatedTranslationsPerPackage = this.getPackageVersionsTranslations(packageVersions);
        return this.generateProperties(updatedTranslationsPerPackage);
    }

    private Map<PackageVersion, Map<String, String>> getPackageVersionsTranslations(List<PackageVersion> packageVersions) {
        LinkedHashMap<PackageVersion, Map<String, String>> updatedTranslationsPerPackage = new LinkedHashMap<PackageVersion, Map<String, String>>();
        for (PackageVersion packageVersion : packageVersions) {
            Map<String, String> updatedTranslations = this.translationProvider.getUpdatedTranslations(packageVersion.getId(), packageVersion.getVersion().toString());
            if (updatedTranslations.isEmpty()) continue;
            updatedTranslationsPerPackage.put(packageVersion, updatedTranslations);
        }
        return updatedTranslationsPerPackage;
    }

    private List<Property> generateProperties(Map<PackageVersion, Map<String, String>> updatedTranslations) {
        List<Property> properties = this.convertToPropertiesList(updatedTranslations);
        this.commentDuplicates(properties);
        return properties;
    }

    private List<Property> convertToPropertiesList(Map<PackageVersion, Map<String, String>> mergedMaps) {
        return mergedMaps.entrySet().stream().flatMap(entry -> {
            PackageVersion packageVersion = (PackageVersion)entry.getKey();
            return ((Map)entry.getValue()).entrySet().stream().map(translationEntry -> new Property((String)translationEntry.getKey(), (String)translationEntry.getValue(), packageVersion));
        }).collect(Collectors.toList());
    }

    private void commentDuplicates(List<Property> properties) {
        properties.stream().collect(Collectors.groupingBy(Property::getKey)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getValue).forEach(sameProperties -> sameProperties.stream().max(Comparator.comparing(property -> property.getPackageVersion().getVersion())).ifPresent(maxVersionProperty -> sameProperties.stream().filter(prop -> prop != maxVersionProperty).forEach(prop -> prop.setCommented(true))));
    }

    public List<Property> overrideTranslations(List<Property> properties, File bundle) throws IOException {
        List<Property> propertiesSnapshot = properties.stream().map(Property::snapshot).collect(Collectors.toList());
        if (bundle.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(bundle);){
                Properties bundleProperties = new Properties();
                bundleProperties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
                bundleProperties.stringPropertyNames().forEach(key -> {
                    List<Property> propertiesToReplace = propertiesSnapshot.stream().filter(property -> property.getKey().equals(key)).filter(property -> property.getCommented() == false).collect(Collectors.toList());
                    if (!propertiesToReplace.isEmpty()) {
                        String newTranslation = bundleProperties.getProperty((String)key);
                        propertiesToReplace.forEach(property -> property.setValue(newTranslation));
                    } else {
                        log.warn("Cannot find key " + key + " in generated translation file");
                    }
                });
            }
        }
        return propertiesSnapshot;
    }
}

