/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl.helper;

import com.suncode.pwfl.i18n.xpdl.PackageVersion;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class Property {
    @NonNull
    private String key;
    @NonNull
    private String value;
    @NonNull
    private PackageVersion packageVersion;
    private Boolean commented = false;

    public void buildString(StringBuilder builder) {
        if (this.commented.booleanValue()) {
            builder.append("# ");
        }
        builder.append(this.key).append("=").append(this.value);
    }

    public Property snapshot() {
        Property property = new Property(this.key, this.value, this.packageVersion);
        property.setCommented(this.commented);
        return property;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    @NonNull
    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public Boolean getCommented() {
        return this.commented;
    }

    public void setKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.key = key;
    }

    public void setValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    public void setPackageVersion(@NonNull PackageVersion packageVersion) {
        if (packageVersion == null) {
            throw new NullPointerException("packageVersion");
        }
        this.packageVersion = packageVersion;
    }

    public void setCommented(Boolean commented) {
        this.commented = commented;
    }

    public String toString() {
        return "Property(key=" + this.getKey() + ", value=" + this.getValue() + ", packageVersion=" + this.getPackageVersion() + ", commented=" + this.getCommented() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @ConstructorProperties(value={"key", "value", "packageVersion"})
    public Property(@NonNull String key, @NonNull String value, @NonNull PackageVersion packageVersion) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (packageVersion == null) {
            throw new NullPointerException("packageVersion");
        }
        this.key = key;
        this.value = value;
        this.packageVersion = packageVersion;
    }
}

