/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.printer.FilePrinter;
import com.suncode.pwfl.i18n.utils.SpringI18NUtils;
import com.suncode.pwfl.i18n.xpdl.XpdlTranslationProvider;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class XpdlTranslationUtils {
    private static final Logger log = LoggerFactory.getLogger(XpdlTranslationUtils.class);

    public static File getDefaultTranslationFile() {
        return new File(I18Nxpdl.PATH_TO_XPDL_BUNDLE + "/" + "xpdlMessages" + ".i18n");
    }

    public static void createTranslation() throws Exception {
        File target = XpdlTranslationUtils.getDefaultTranslationFile();
        if (!target.exists()) {
            XpdlTranslationUtils.updateTranslation(target);
        }
    }

    public static void updateTranslation() throws Exception {
        XpdlTranslationUtils.updateTranslation(XpdlTranslationUtils.getDefaultTranslationFile());
    }

    public static void updateTranslation(File bundle) throws Exception {
        Assert.notNull((Object)bundle, (String)"XPDL bundle file must not be null");
        RepositoryPersistenceManager repositoryManager = XpdlTranslationUtils.getRepositoryManagerByReflection();
        RepositoryTransaction transaction = Shark.getInstance().createRepositoryTransaction();
        try {
            LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
            List packages = repositoryManager.getExistingXPDLIds(transaction);
            for (String packageId : packages) {
                translations.putAll(XpdlTranslationUtils.getPackageTranslation(packageId, transaction, repositoryManager));
            }
            FileUtils.forceMkdir((File)bundle.getParentFile());
            FilePrinter printer = new FilePrinter(bundle);
            printer.printProperties(translations);
            AbstractI18N.refresh();
            transaction.commit();
        }
        catch (Error e) {
            log.error(e.getMessage(), (Throwable)e);
            XpdlTranslationUtils.rollbackTransaction(transaction, e);
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            XpdlTranslationUtils.rollbackTransaction(transaction, e);
            throw e;
        }
        finally {
            transaction.release();
        }
    }

    private static Map<String, String> getPackageTranslation(String packageId, RepositoryTransaction transaction, RepositoryPersistenceManager repositoryManager) throws Exception {
        XpdlTranslationProvider translationProvider = (XpdlTranslationProvider)SpringI18NUtils.getContext().getBean(XpdlTranslationProvider.class);
        LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
        List versions = repositoryManager.getXPDLVersions(transaction, packageId);
        Collections.sort(versions, Comparator.comparingInt(Integer::valueOf));
        for (String version : versions) {
            try {
                translations.putAll(translationProvider.getTranslation(packageId, version));
            }
            catch (Exception e) {
                log.warn("Could not parse XPDL package (id: {}, version: {})", new Object[]{packageId, version, e});
            }
        }
        return translations;
    }

    private static void rollbackTransaction(RepositoryTransaction transaction, Throwable ex) throws TransactionException {
        try {
            transaction.rollback();
        }
        catch (TransactionException e) {
            log.error("Rollback transakcji zako\u0144czony b\u0142\u0119dem. Pow\u00f3d dla kt\u00f3rego przeprowadzany jest rollback: ", ex);
            throw e;
        }
    }

    private static RepositoryPersistenceManager getRepositoryManagerByReflection() {
        try {
            Method getInstance = SharkEngineManager.class.getDeclaredMethod("getInstance", new Class[0]);
            Method getRepositoryPersistenceManager = SharkEngineManager.class.getDeclaredMethod("getRepositoryPersistenceManager", new Class[0]);
            getInstance.setAccessible(true);
            getRepositoryPersistenceManager.setAccessible(true);
            SharkEngineManager engineManager = (SharkEngineManager)getInstance.invoke(null, new Object[0]);
            return (RepositoryPersistenceManager)getRepositoryPersistenceManager.invoke((Object)engineManager, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Nie uda\u0142o si\u0119 pobra\u0107 obiektu [" + RepositoryPersistenceManager.class + "] przez refleksj\u0119", e);
        }
    }
}

