/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class PackageTranslationHelper {
    private static String generateXpdlRoleKey(String packageId, String processDefId, String roleId) {
        return XpdlKey.forPackage((String)packageId).forProcess(processDefId).forParticipant(roleId).getKey();
    }

    private static String generateXpdlRoleKey(String packageId, String roleId) {
        return XpdlKey.forPackage((String)packageId).forParticipant(roleId).getKey();
    }

    public static String getRoleName(String packageId, String processDefId, String roleId) {
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        if (StringUtils.isNotBlank((String)processDefId)) {
            return xpdl.getString(PackageTranslationHelper.generateXpdlRoleKey(packageId, processDefId, roleId), PackageTranslationHelper.generateXpdlRoleKey(packageId, roleId));
        }
        return xpdl.getString(PackageTranslationHelper.generateXpdlRoleKey(packageId, roleId));
    }

    public static String getProcessName(String packageId, String processDefId) {
        if (StringUtils.isBlank((String)processDefId)) {
            return null;
        }
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        return xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(processDefId).forProcessNameMask().getKey());
    }

    public static String getProcessName(String packageId, String processDefId, String mask) {
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        String name = xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(processDefId).forProcessNameMask().getKey());
        return mask.replace("process_name_mask", name);
    }

    public static String getProcessDescription(String packageId, String processDefId) {
        if (StringUtils.isBlank((String)processDefId)) {
            return null;
        }
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        return xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(processDefId).getKeyDesc());
    }

    public static String getPackageName(String packageId) {
        if (StringUtils.isBlank((String)packageId)) {
            return null;
        }
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        return xpdl.getString(XpdlKey.forPackage((String)packageId).getKey());
    }

    public static String getActivityName(String packageId, String processDefId, String activityDefId) {
        if (StringUtils.isBlank((String)processDefId)) {
            return null;
        }
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        return xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(processDefId).forActivity(activityDefId).getKey());
    }

    public static String getActivityDescription(String packageId, String processDefId, String activityDefId) {
        if (StringUtils.isBlank((String)processDefId)) {
            return null;
        }
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        return xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(processDefId).forActivity(activityDefId).getKeyDesc());
    }

    public static boolean isRoleTranslationExists(String packageId, String processDefId, String roleId) {
        String key;
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        if (StringUtils.isNotBlank((String)processDefId) && xpdl.containsTranslation(key = PackageTranslationHelper.generateXpdlRoleKey(packageId, processDefId, roleId))) {
            return true;
        }
        key = PackageTranslationHelper.generateXpdlRoleKey(packageId, roleId);
        return xpdl.containsTranslation(key);
    }
}

