/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.suncode.pwfl.i18n.xpdl.ExportDateProvider;
import com.suncode.pwfl.i18n.xpdl.PackageVersion;
import com.suncode.pwfl.i18n.xpdl.helper.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TranslationOverrider {
    private static final Logger log = LoggerFactory.getLogger(TranslationOverrider.class);
    @Autowired
    private ExportDateProvider exportDateProvider;

    public List<Property> overrideTranslations(List<Property> originalProperties, File bundleFile, Boolean packageWasUpdated, Map<String, String> additionalTranslations) throws IOException {
        List<Property> properties = this.copy(originalProperties);
        if (bundleFile.exists()) {
            Date latestExport = this.exportDateProvider.getLatestExportDate();
            this.overrideByBundleProperties(bundleFile, properties, packageWasUpdated, latestExport);
            this.overrideByAdditionalTranslations(properties, additionalTranslations);
            this.addCommentedBundleProperties(bundleFile, properties);
            this.removeDuplicated(properties);
        }
        return properties;
    }

    private void overrideByBundleProperties(File bundleFile, List<Property> propertiesToOverride, Boolean packageWasUpdated, Date latestExport) throws IOException {
        Multimap<String, String> bundleProperties = this.toProperties(bundleFile);
        if (packageWasUpdated.booleanValue()) {
            this.packageUpdatedOverride(propertiesToOverride, bundleProperties, latestExport);
        } else {
            this.packagesRefreshedOverride(propertiesToOverride, bundleProperties);
        }
    }

    public Multimap<String, String> toProperties(File propertiesFile) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
            Properties properties = new Properties();
            properties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            LinkedHashMultimap result = LinkedHashMultimap.create();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> TranslationOverrider.lambda$toProperties$0((Multimap)result, arg_0, arg_1)));
            LinkedHashMultimap linkedHashMultimap = result;
            return linkedHashMultimap;
        }
    }

    private void overrideByAdditionalTranslations(List<Property> propertiesToOverride, Map<String, String> additionalTranslations) {
        LinkedHashMultimap additionalTranslationsMultimap = LinkedHashMultimap.create();
        additionalTranslations.forEach((arg_0, arg_1) -> ((Multimap)additionalTranslationsMultimap).put(arg_0, arg_1));
        this.forceOverride(propertiesToOverride, (Multimap<String, String>)additionalTranslationsMultimap);
    }

    private void packageUpdatedOverride(List<Property> propertiesToOverride, Multimap<String, String> overrideProperties, Date latestExportDate) {
        List<Property> fromLatestPackage = this.copy(propertiesToOverride.stream().filter(property -> property.getPackageVersion().get().getExportDate().equals(latestExportDate)).collect(Collectors.toList()));
        this.packagesRefreshedOverride(propertiesToOverride, overrideProperties);
        fromLatestPackage.forEach(latestPackageProperty -> {
            String key = latestPackageProperty.getKey();
            String value = latestPackageProperty.getValue();
            this.findByKey(propertiesToOverride, key).stream().filter(property -> !property.getValue().equals(value)).filter(property -> property.getCommented() == false).forEachOrdered(property -> this.commentOldAndAdd(propertiesToOverride, key, value));
        });
    }

    private void packagesRefreshedOverride(List<Property> propertiesToOverride, Multimap<String, String> overrideProperties) {
        this.forEach(overrideProperties, (key, keyValue) -> {
            String value = StringUtils.defaultString((String)keyValue);
            if (this.contains(propertiesToOverride, (String)key)) {
                this.findByKey(propertiesToOverride, (String)key).stream().filter(property -> !property.getValue().equals(value)).filter(property -> property.getCommented() == false).forEachOrdered(property -> property.setValue(value));
            } else {
                this.addUnknownPackageProperty(propertiesToOverride, (String)key, value, false);
            }
        });
    }

    private void forceOverride(List<Property> propertiesToOverride, Multimap<String, String> overrideProperties) {
        this.forEach(overrideProperties, (key, keyValue) -> {
            String value = StringUtils.defaultString((String)keyValue);
            if (this.contains(propertiesToOverride, (String)key)) {
                boolean alreadyExists = this.findByKeyAndValue(propertiesToOverride, (String)key, value).stream().anyMatch(property -> property.getCommented() == false);
                if (!alreadyExists) {
                    this.commentOldAndAdd(propertiesToOverride, (String)key, value);
                }
            } else {
                this.addUnknownPackageProperty(propertiesToOverride, (String)key, value, false);
            }
        });
    }

    private void commentOldAndAdd(List<Property> propertiesSnapshot, String key, String value) {
        this.findByKey(propertiesSnapshot, key).stream().filter(property -> property.getCommented() == false).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(oldProperty -> {
            oldProperty.setCommented(true);
            Property bundleProperty = this.copyAndSet((Property)oldProperty, value, false);
            this.addBundleProperty(propertiesSnapshot, (Property)oldProperty, bundleProperty, true);
        });
    }

    private List<Property> findToOverride(List<Property> propertiesSnapshot, String key, String value, Date lastExportDate, Boolean packageWasUpdated) {
        if (!packageWasUpdated.booleanValue()) {
            return this.findByKey(propertiesSnapshot, key).stream().filter(property -> !property.getValue().equals(value)).filter(property -> property.getCommented() == false).filter(property -> !this.exportDateEquals((Property)property, lastExportDate)).collect(Collectors.toList());
        }
        return new LinkedList<Property>();
    }

    private void addCommentedBundleProperties(File bundle, List<Property> propertiesSnapshot) throws IOException {
        Multimap<String, String> commentedBundleProperties = this.loadCommentedPropertiesMap(bundle);
        LinkedList propertiesToAdd = new LinkedList();
        this.forEach(commentedBundleProperties, (key, value) -> {
            List<Property> sameKeyProperties = this.findByKey(propertiesSnapshot, (String)key);
            if (!sameKeyProperties.isEmpty()) {
                boolean alreadyExists = this.findByKeyAndValue(propertiesSnapshot, (String)key, (String)value).stream().anyMatch(Property::getCommented);
                if (!alreadyExists) {
                    sameKeyProperties.stream().filter(property -> property.getPackageVersion().isPresent()).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(property -> {
                        Property snapshotProperty = this.copyAndSet((Property)property, (String)value, true);
                        propertiesToAdd.add(snapshotProperty);
                    });
                }
            } else {
                this.addUnknownPackageProperty(propertiesSnapshot, (String)key, (String)value, true);
            }
        });
        Collections.reverse(propertiesToAdd);
        propertiesToAdd.forEach(newProperty -> {
            if (newProperty.getPackageVersion().isPresent()) {
                propertiesSnapshot.stream().filter(property -> property.getPackageVersion().isPresent()).filter(property -> property.getKey().equals(newProperty.getKey())).max(Comparator.comparing(property -> property.getPackageVersion().get().getExportDate())).ifPresent(lastUncommentedProperty -> this.addBundleProperty(propertiesSnapshot, (Property)lastUncommentedProperty, (Property)newProperty, false));
            } else {
                propertiesSnapshot.add((Property)newProperty);
            }
        });
    }

    private Multimap<String, String> loadCommentedPropertiesMap(File propertiesFile) throws IOException {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        Files.lines(propertiesFile.toPath()).filter(line -> line.matches("\\s*#\\s*[^= :]*=[^=]*$")).map(line -> line.replaceFirst("#", "")).map(line -> line.split("=", -1)).forEachOrdered(arg_0 -> TranslationOverrider.lambda$loadCommentedPropertiesMap$30((Multimap)result, arg_0));
        return result;
    }

    private void removeDuplicated(List<Property> properties) {
        List filteredProperties = properties.stream().filter(this.isNotBlank()).filter(this.distinctByKey(Property::hashCodeIgnorePackage)).collect(Collectors.toList());
        properties.clear();
        properties.addAll(filteredProperties);
    }

    public <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public Predicate<Property> isNotBlank() {
        return p -> StringUtils.isNotBlank((String)p.getValue());
    }

    private List<Property> copy(List<Property> properties) {
        return properties.stream().map(Property::snapshot).collect(Collectors.toList());
    }

    private List<Property> findByKey(List<Property> propertiesSnapshot, String key) {
        return propertiesSnapshot.stream().filter(property -> property.getKey().equals(key)).collect(Collectors.toList());
    }

    private boolean contains(List<Property> properties, String key) {
        return !this.findByKey(properties, key).isEmpty();
    }

    private List<Property> findByKeyAndValue(List<Property> properties, String key, String value) {
        return this.findByKey(properties, key).stream().filter(property -> property.getValue().equals(value)).collect(Collectors.toList());
    }

    private Property copyAndSet(Property property, String value, Boolean commented) {
        Property bundleProperty = property.snapshot();
        bundleProperty.setValue(value);
        bundleProperty.setCommented(commented);
        return bundleProperty;
    }

    private void addBundleProperty(List<Property> propertiesSnapshot, Property propertyPlacement, Property bundleProperty, Boolean after) {
        int index = propertiesSnapshot.indexOf(propertyPlacement);
        if (index >= 0) {
            propertiesSnapshot.add(after != false ? index + 1 : index, bundleProperty);
        } else {
            log.warn("Cannot find index of property " + propertyPlacement.getKey());
            propertiesSnapshot.add(bundleProperty);
        }
    }

    private void addUnknownPackageProperty(List<Property> propertiesSnapshot, String key, String value, Boolean commented) {
        Property unknownPackageProperty = new Property(key, value, Optional.empty());
        unknownPackageProperty.setCommented(commented);
        propertiesSnapshot.add(unknownPackageProperty);
    }

    private boolean exportDateEquals(Property property, Date date) {
        Optional<PackageVersion> optionalPackageVersion = property.getPackageVersion();
        if (optionalPackageVersion.isPresent()) {
            Date exportDate = optionalPackageVersion.get().getExportDate();
            return exportDate.equals(date);
        }
        return false;
    }

    private <T, K> void forEach(Multimap<T, K> multimap, BiConsumer<T, K> consumer) {
        multimap.keySet().forEach(key -> multimap.get(key).forEach(value -> consumer.accept(key, value)));
    }

    private static /* synthetic */ void lambda$loadCommentedPropertiesMap$30(Multimap result, String[] array) {
        result.put((Object)array[0].trim(), (Object)array[1].trim());
    }

    private static /* synthetic */ void lambda$toProperties$0(Multimap result, Object key, Object value) {
        result.put((Object)key.toString(), (Object)value.toString());
    }
}

