/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.i18n;

import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.i18n.CustomControlI18N;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class I18NCustom
extends AbstractI18N {
    public static final Logger log = Logger.getLogger(I18NCustom.class);
    private static String PATH_TO_CUSTOM_BUNDLE;
    public static final String S_BUNDLE_BASE_NAME = "customMessages";
    private static boolean initilized;

    public I18NCustom() {
    }

    public static void initialize(String pathToCustomBundle) {
        if (pathToCustomBundle != null) {
            initilized = true;
        }
        PATH_TO_CUSTOM_BUNDLE = pathToCustomBundle;
    }

    public I18NCustom(Locale locale) {
        super(locale);
    }

    public I18NCustom(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    @Override
    public String getString(String sKey) {
        if (initilized) {
            String transformedKey = null;
            try {
                transformedKey = this.getAsProperty(sKey);
                return this.bundle.getString(transformedKey);
            }
            catch (MissingResourceException mre) {
                log.debug((Object)("Brak tekstu dla klucza: [" + transformedKey + "]. Wersja j\u0119zykowa: " + this.getLang()));
            }
            catch (ClassCastException cce) {
                log.error((Object)("Warto\u015b\u0107 dla klucza: [" + transformedKey + "] nie jest typu java.lang.String. Wersja j\u0119zykowa: " + this.getLang()), (Throwable)cce);
            }
            catch (NullPointerException npe) {
                log.debug((Object)"Warto\u015b\u0107 klucza jest nullem");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return sKey;
        }
        return sKey;
    }

    @Override
    public String getStringSilent(String key) {
        if (initilized) {
            String transformedKey = null;
            try {
                transformedKey = this.getAsProperty(key);
                return this.bundle.getString(transformedKey);
            }
            catch (Exception exception) {
                return key;
            }
        }
        return key;
    }

    private String getAsProperty(String name) {
        name = name.replaceAll("[ \t]+", "_");
        return name;
    }

    @Override
    public void populateBundle() {
        if (initilized) {
            this.bundle = ResourceBundle.getBundle(S_BUNDLE_BASE_NAME, this.locale, new CustomControlI18N(PATH_TO_CUSTOM_BUNDLE));
        }
    }
}

