/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.i18n;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class AbstractI18N {
    private static final Logger log = Logger.getLogger(AbstractI18N.class);
    protected Locale locale;
    protected ResourceBundle bundle;

    public AbstractI18N() {
        log.trace((Object)"Ustawiam domy\u015bln\u0105 lokalizacj\u0119 u\u017cytkownika...");
        this.locale = Locale.getDefault();
        log.trace((Object)("Ustawiono: " + this.locale.getLanguage()));
        this.populateBundle();
    }

    public AbstractI18N(Locale locale) {
        log.trace((Object)"Ustawiam lokalizacj\u0119 u\u017cytkownika...");
        this.locale = locale;
        log.trace((Object)("Ustawiono: " + locale.getLanguage()));
        this.populateBundle();
    }

    public AbstractI18N(HttpServletRequest request) {
        log.trace((Object)"Ustawiam lokalizacj\u0119 u\u017cytkownika, sprawdzaj\u0105c czy ma w sesji zapisane obiekt ustawie\u0144 j\u0119zykowych...");
        this.locale = AbstractI18N.getLocale(request);
        log.trace((Object)("Ustawiono: " + this.locale.getLanguage()));
        this.populateBundle();
    }

    public static Locale getFromBrowserSettings(HttpServletRequest httpServletRequest) {
        log.debug((Object)"Pobieram ustawienia j\u0119zykowe z ustawie\u0144 przegl\u0105darki");
        Enumeration enumLocales = httpServletRequest.getLocales();
        Locale locale = (Locale)enumLocales.nextElement();
        log.debug((Object)("Pobrano: " + locale.getLanguage()));
        return locale;
    }

    public static Locale getFromUserSettings(String username) {
        log.debug((Object)"Pobieram ustawienia j\u0119zykowe z ustawie\u0144 u\u017cytkownika");
        return Locale.getDefault();
    }

    public static List<Locale> getSupportedLocales() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        String supportedLangs = Shark.getInstance().getProperties().getProperty("SupportedLanguages", "pl;en");
        ArrayList<String> langs = new ArrayList<String>(Arrays.asList(supportedLangs.split(";")));
        for (String lang : langs) {
            supportedLocales.add(new Locale(lang));
        }
        return supportedLocales;
    }

    @Deprecated
    public static Locale getLocale(HttpServletRequest request) {
        return LocaleContextHolder.getLocale();
    }

    public static void setSessionLocale(HttpSession session, String localeName) {
        log.debug((Object)("Ustawiam w sesji ustawienia jezykowe uzytkownika na " + localeName));
        Locale locale = null;
        if (!localeName.equals("default")) {
            locale = new Locale(localeName);
        }
        session.setAttribute("org.apache.struts.action.LOCALE", locale);
    }

    public static void removeSessionLocale(HttpSession session) {
        log.debug((Object)"Usuwam z sesji ustawienia jezykowe uzytkownika");
        session.removeAttribute("org.apache.struts.action.LOCALE");
    }

    public String getLang() {
        return this.locale.getLanguage();
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public static void refresh() {
        log.debug((Object)"Odwiezam paczke zasob\u00f3w");
        ResourceBundle.clearCache();
    }

    public abstract void populateBundle();

    public abstract String getString(String var1);

    public abstract String getStringSilent(String var1);

    public String getStringOrDefault(String key, String defaultValue) {
        if (this.bundle != null && this.bundle.containsKey(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }
}

