/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n.xpdl;

import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.XpdlParser;
import com.plusmpm.parser.printer.FilePrinter;
import com.plusmpm.parser.xpdlelements.Package;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class XpdlTranslationUtils {
    private static final Logger logger = LoggerFactory.getLogger(XpdlTranslationUtils.class);

    public static File getDefaultTranslationFile() {
        return new File(I18Nxpdl.PATH_TO_XPDL_BUNDLE + "/" + "xpdlMessages" + ".i18n");
    }

    public static void createTranslation() throws Exception {
        File target = XpdlTranslationUtils.getDefaultTranslationFile();
        if (!target.exists()) {
            XpdlTranslationUtils.updateTranslation(target);
        }
    }

    public static void updateTranslation() throws Exception {
        XpdlTranslationUtils.updateTranslation(XpdlTranslationUtils.getDefaultTranslationFile());
    }

    public static void updateTranslation(File bundle) throws Exception {
        Assert.notNull((Object)bundle, (String)"XPDL bundle file must not be null");
        RepositoryPersistenceManager repositoryManager = XpdlTranslationUtils.getRepositoryManagerByReflection();
        RepositoryTransaction transaction = Shark.getInstance().createRepositoryTransaction();
        try {
            LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
            List packages = repositoryManager.getExistingXPDLIds(transaction);
            for (String packageId : packages) {
                translations.putAll(XpdlTranslationUtils.getPackageTranslation(packageId, transaction, repositoryManager));
            }
            FileUtils.forceMkdir((File)bundle.getParentFile());
            FilePrinter printer = new FilePrinter(bundle);
            printer.printProperties(translations);
            AbstractI18N.refresh();
            transaction.commit();
        }
        catch (Error e) {
            XpdlTranslationUtils.rollbackTransaction(transaction, e);
            throw e;
        }
        catch (Exception e) {
            XpdlTranslationUtils.rollbackTransaction(transaction, e);
            throw e;
        }
        finally {
            transaction.release();
        }
    }

    private static Map<String, String> getPackageTranslation(String packageId, RepositoryTransaction transaction, RepositoryPersistenceManager repositoryManager) throws Exception {
        LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
        List versions = repositoryManager.getXPDLVersions(transaction, packageId);
        Collections.sort(versions, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
            }
        });
        for (String version : versions) {
            byte[] content = repositoryManager.getXPDL(transaction, packageId, version);
            try {
                Package parsedPackage = XpdlParser.parse((byte[])content);
                translations.putAll(parsedPackage.getProperties());
            }
            catch (Exception e) {
                logger.warn("Could not parse XPDL package (id: {}, version: {})", new Object[]{packageId, version, e});
            }
        }
        return translations;
    }

    private static void rollbackTransaction(RepositoryTransaction transaction, Throwable ex) throws TransactionException {
        try {
            transaction.rollback();
        }
        catch (TransactionException e) {
            logger.error("Rollback transakcji zako\u0144czony b\u0142\u0119dem. Pow\u00f3d dla kt\u00f3rego przeprowadzany jest rollback: ", ex);
            throw e;
        }
    }

    private static RepositoryPersistenceManager getRepositoryManagerByReflection() {
        try {
            Method getInstance = SharkEngineManager.class.getDeclaredMethod("getInstance", new Class[0]);
            Method getRepositoryPersistenceManager = SharkEngineManager.class.getDeclaredMethod("getRepositoryPersistenceManager", new Class[0]);
            getInstance.setAccessible(true);
            getRepositoryPersistenceManager.setAccessible(true);
            SharkEngineManager engineManager = (SharkEngineManager)getInstance.invoke(null, new Object[0]);
            return (RepositoryPersistenceManager)getRepositoryPersistenceManager.invoke((Object)engineManager, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Nie uda\u0142o si\u0119 pobra\u0107 obiektu [" + RepositoryPersistenceManager.class + "] przez refleksj\u0119", e);
        }
    }
}

