/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.scheduledtask.info;

import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskParameterInfo;
import com.suncode.pwfl.administration.scheduledtask.info.exceptions.ScheduledTaskParameterNotFoundException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTaskContext {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskContext.class);
    private final List<ScheduledTaskParameterInfo> parameterInfos;

    public ScheduledTaskContext(List<ScheduledTaskParameterInfo> parameterInfos) {
        this.parameterInfos = Collections.unmodifiableList(parameterInfos);
    }

    public String getValue(int parameterPosition) {
        ScheduledTaskParameterInfo parameterInfo = this.getByParameterPosition(parameterPosition);
        return parameterInfo.getValue();
    }

    public String getValue(String parameterId) {
        ScheduledTaskParameterInfo parameterInfo = this.getByParameterId(parameterId);
        return parameterInfo.getValue();
    }

    public void setValue(int parameterPosition, String value) {
        ScheduledTaskParameterInfo parameterInfo = this.getByParameterPosition(parameterPosition);
        parameterInfo.setValue(value);
    }

    public void setValue(String parameterId, String value) {
        ScheduledTaskParameterInfo parameterInfo = this.getByParameterId(parameterId);
        parameterInfo.setValue(value);
    }

    public ScheduledTaskParameterInfo getByParameterPosition(int parameterPosition) {
        return this.parameterInfos.stream().filter(parameterInfo -> parameterInfo.getParameterPosition().equals(parameterPosition)).findFirst().orElseThrow(() -> new ScheduledTaskParameterNotFoundException("Nie znaleziono parametru"));
    }

    public ScheduledTaskParameterInfo getByParameterId(String parameterId) {
        return this.parameterInfos.stream().filter(ScheduledTaskParameterInfo::isComponent).filter(parameterInfo -> parameterInfo.getParameterId().equals(parameterId)).findFirst().orElseThrow(() -> new ScheduledTaskParameterNotFoundException("Nie znaleziono parametru"));
    }

    public List<ScheduledTaskParameterInfo> getParameterInfos() {
        return this.parameterInfos;
    }
}

